/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.model;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.model.ModelRenderer;
import thebetweenlands.client.render.model.MowzieModelBase;

public class AnimationBlender<T extends MowzieModelBase> {
    private final T model;
    private final State baseState;
    private final List<State> states = new ArrayList<State>();
    private final float[] rotX;
    private final float[] rotY;
    private final float[] rotZ;

    public AnimationBlender(T model) {
        this.model = model;
        this.baseState = new State(m -> {}, () -> Float.valueOf(1.0f));
        this.states.add(this.baseState);
        this.rotX = new float[((MowzieModelBase)((Object)this.model)).field_78092_r.size()];
        this.rotY = new float[((MowzieModelBase)((Object)this.model)).field_78092_r.size()];
        this.rotZ = new float[((MowzieModelBase)((Object)this.model)).field_78092_r.size()];
    }

    public void addState(Consumer<T> animator, Supplier<Float> weight) {
        this.states.add(new State(animator, weight));
    }

    public void setAngles(boolean useExistingAngles) {
        for (int i = 0; i < ((MowzieModelBase)((Object)this.model)).field_78092_r.size(); ++i) {
            this.rotZ[i] = 0.0f;
            this.rotY[i] = 0.0f;
            this.rotX[i] = 0.0f;
        }
        for (State state : this.states) {
            if (!useExistingAngles && state == this.baseState) continue;
            state.currentWeight = ((Float)state.weight.get()).floatValue();
            state.update(this, (Object)((Object)this.model), state != this.baseState);
        }
        for (int i = 0; i < ((MowzieModelBase)((Object)this.model)).field_78092_r.size(); ++i) {
            ModelRenderer part = (ModelRenderer)((MowzieModelBase)((Object)this.model)).field_78092_r.get(i);
            part.field_78795_f = this.rotX[i];
            part.field_78796_g = this.rotY[i];
            part.field_78808_h = this.rotZ[i];
        }
    }

    private class State {
        private final Consumer<T> animator;
        private final Supplier<Float> weight;
        private float currentWeight;

        private State(Consumer<T> animator, Supplier<Float> weight) {
            this.animator = animator;
            this.weight = weight;
        }

        private void update(AnimationBlender<T> blender, T model, boolean reset) {
            ModelRenderer part;
            int i;
            if (reset) {
                for (i = 0; i < ((MowzieModelBase)((Object)model)).field_78092_r.size(); ++i) {
                    part = (ModelRenderer)((MowzieModelBase)((Object)model)).field_78092_r.get(i);
                    part.field_78795_f = Float.NaN;
                    part.field_78796_g = Float.NaN;
                    part.field_78808_h = Float.NaN;
                }
            }
            this.animator.accept(model);
            for (i = 0; i < ((MowzieModelBase)((Object)model)).field_78092_r.size(); ++i) {
                part = (ModelRenderer)((MowzieModelBase)((Object)model)).field_78092_r.get(i);
                if (Float.isFinite(part.field_78795_f)) {
                    float[] fArray = blender.rotX;
                    int n = i;
                    fArray[n] = fArray[n] + this.currentWeight * part.field_78795_f;
                }
                if (Float.isFinite(part.field_78796_g)) {
                    float[] fArray = blender.rotY;
                    int n = i;
                    fArray[n] = fArray[n] + this.currentWeight * part.field_78796_g;
                }
                if (!Float.isFinite(part.field_78808_h)) continue;
                float[] fArray = blender.rotZ;
                int n = i;
                fArray[n] = fArray[n] + this.currentWeight * part.field_78808_h;
            }
        }
    }
}

