/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.model.entity.ModelJellyfish;
import thebetweenlands.client.render.shader.LightSource;
import thebetweenlands.client.render.shader.ShaderHelper;
import thebetweenlands.common.entity.mobs.EntityJellyfish;
import thebetweenlands.util.LightingUtil;

@SideOnly(value=Side.CLIENT)
public class RenderJellyfish<T extends EntityJellyfish>
extends RenderLiving<T> {
    private static final ResourceLocation[] TEXTURE = new ResourceLocation[]{new ResourceLocation("thebetweenlands:textures/entity/jellyfish_1.png"), new ResourceLocation("thebetweenlands:textures/entity/jellyfish_2.png"), new ResourceLocation("thebetweenlands:textures/entity/jellyfish_3.png"), new ResourceLocation("thebetweenlands:textures/entity/jellyfish_4.png"), new ResourceLocation("thebetweenlands:textures/entity/jellyfish_5.png")};
    private static final float[][] GLOW_COLORS = new float[][]{{0.93333334f, 0.6784314f, 0.44705883f}, {0.7058824f, 0.16470589f, 0.16470589f}, {0.8784314f, 0.3254902f, 0.42352942f}, {0.3529412f, 0.6666667f, 0.5686275f}, {0.84313726f, 0.6901961f, 0.7647059f}};
    private static final ModelJellyfish MODEL = new ModelJellyfish();

    public RenderJellyfish(RenderManager manager) {
        super(manager, (ModelBase)MODEL, 0.5f);
    }

    public RenderJellyfish(RenderManager manager, ModelBase model) {
        super(manager, model, 0.5f);
    }

    protected ResourceLocation getEntityTexture(EntityJellyfish entity) {
        return TEXTURE[entity.getJellyfishColour()];
    }

    public void doRender(T jellofooosh, double x, double y, double z, float entityYaw, float partialTicks) {
        super.func_76986_a(jellofooosh, x, y + (double)(((EntityJellyfish)jellofooosh).field_70131_O * 0.5f), z, entityYaw, partialTicks);
        this.addLighting(jellofooosh, partialTicks);
    }

    protected void addLighting(T jellofooosh, float partialTicks) {
        if (ShaderHelper.INSTANCE.isWorldShaderActive()) {
            double interpX = ((EntityJellyfish)jellofooosh).field_70142_S + (((EntityJellyfish)jellofooosh).field_70165_t - ((EntityJellyfish)jellofooosh).field_70142_S) * (double)partialTicks;
            double interpY = ((EntityJellyfish)jellofooosh).field_70137_T + (((EntityJellyfish)jellofooosh).field_70163_u - ((EntityJellyfish)jellofooosh).field_70137_T) * (double)partialTicks;
            double interpZ = ((EntityJellyfish)jellofooosh).field_70136_U + (((EntityJellyfish)jellofooosh).field_70161_v - ((EntityJellyfish)jellofooosh).field_70136_U) * (double)partialTicks;
            float str = 5.0f * ((EntityJellyfish)jellofooosh).getJellyfishSize();
            float[] colors = GLOW_COLORS[((EntityJellyfish)jellofooosh).getJellyfishColour()];
            ShaderHelper.INSTANCE.require();
            ShaderHelper.INSTANCE.getWorldShader().addLight(new LightSource(interpX, interpY, interpZ, 3.0f, str * colors[0], str * colors[1], str * colors[2]));
        }
    }

    public float prepareScale(T jellofooosh, float partialTicks) {
        float scale = ((EntityJellyfish)jellofooosh).getJellyfishSize();
        GlStateManager.func_179152_a((float)scale, (float)(scale * ((EntityJellyfish)jellofooosh).getJellyfishLength()), (float)scale);
        float limbSwingAmount = ((EntityJellyfish)jellofooosh).field_184618_aE + (((EntityJellyfish)jellofooosh).field_70721_aZ - ((EntityJellyfish)jellofooosh).field_184618_aE) * partialTicks;
        float limbSwing = ((EntityJellyfish)jellofooosh).field_184619_aG - ((EntityJellyfish)jellofooosh).field_70721_aZ * (1.0f - partialTicks);
        GlStateManager.func_179152_a((float)(1.0f + MathHelper.func_76126_a((float)limbSwing) * Math.min(limbSwingAmount, 0.2f) * 2.0f), (float)(1.0f - MathHelper.func_76126_a((float)limbSwing) * Math.min(limbSwingAmount, 0.2f)), (float)(1.0f + MathHelper.func_76126_a((float)limbSwing) * Math.min(limbSwingAmount, 0.2f) * 2.0f));
        return super.func_188322_c(jellofooosh, partialTicks);
    }

    protected void renderModel(T jellofooosh, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179089_o();
        LightingUtil.INSTANCE.setLighting(255);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GlStateManager.func_179132_a((boolean)false);
        Minecraft.func_71410_x().field_71460_t.func_191514_d(true);
        super.func_77036_a(jellofooosh, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
        Minecraft.func_71410_x().field_71460_t.func_191514_d(false);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        super.func_77036_a(jellofooosh, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
        LightingUtil.INSTANCE.revert();
        GlStateManager.func_179129_p();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179084_k();
    }

    protected static double interpolate(double prev, double now, double partialTicks) {
        return prev + (now - prev) * partialTicks;
    }

    protected void applyRotations(T jellofooosh, float ageInTicks, float rotationYaw, float partialTicks) {
        Vec3d weightPos = ((EntityJellyfish)jellofooosh).getOrientationPos(partialTicks);
        double dx = RenderJellyfish.interpolate(((EntityJellyfish)jellofooosh).field_70142_S, ((EntityJellyfish)jellofooosh).field_70165_t, partialTicks) - weightPos.field_72450_a;
        double dy = RenderJellyfish.interpolate(((EntityJellyfish)jellofooosh).field_70137_T, ((EntityJellyfish)jellofooosh).field_70163_u, partialTicks) - weightPos.field_72448_b;
        double dz = RenderJellyfish.interpolate(((EntityJellyfish)jellofooosh).field_70136_U, ((EntityJellyfish)jellofooosh).field_70161_v, partialTicks) - weightPos.field_72449_c;
        float yaw = -((float)Math.toDegrees(MathHelper.func_181159_b((double)dz, (double)dx)));
        float pitch = (float)Math.toDegrees(MathHelper.func_181159_b((double)Math.sqrt(dx * dx + dz * dz), (double)(-dy))) - 180.0f;
        GlStateManager.func_179114_b((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)pitch, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)(-yaw), (float)0.0f, (float)1.0f, (float)0.0f);
    }
}

