/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import thebetweenlands.client.handler.DebugHandlerClient;
import thebetweenlands.client.render.model.entity.ModelRopeNode;
import thebetweenlands.client.render.model.entity.ModelShambler;
import thebetweenlands.client.render.particle.entity.ParticleBeam;
import thebetweenlands.common.entity.EntityGrapplingHookNode;
import thebetweenlands.common.item.misc.ItemGrapplingHook;
import thebetweenlands.common.item.misc.ItemMisc;
import thebetweenlands.util.RotationMatrix;

public class RenderGrapplingHookNode
extends Render<EntityGrapplingHookNode> {
    private Frustum frustum = new Frustum();
    protected static final ResourceLocation TEXTURE_ROPE = new ResourceLocation("thebetweenlands:textures/entity/grappling_hook_rope.png");
    protected static final ResourceLocation TEXTURE_SHAMBLER = new ResourceLocation("thebetweenlands:textures/entity/shambler.png");
    protected static final ModelRopeNode nodeModel = new ModelRopeNode();
    protected static final ModelShambler shamblerModel = new ModelShambler();
    protected final RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
    protected final ItemStack anglerTooth = ItemMisc.EnumItemMisc.ANGLER_TOOTH.create(1);

    public RenderGrapplingHookNode(RenderManager renderManager) {
        super(renderManager);
    }

    public void doRender(EntityGrapplingHookNode entity, double x, double y, double z, float yaw, float partialTicks) {
        Entity nextNode;
        this.func_180548_c(entity);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        double camPosX = RenderGrapplingHookNode.interpolate(entity.field_70142_S, entity.field_70165_t, partialTicks) - x;
        double camPosY = RenderGrapplingHookNode.interpolate(entity.field_70137_T, entity.field_70163_u, partialTicks) - y;
        double camPosZ = RenderGrapplingHookNode.interpolate(entity.field_70136_U, entity.field_70161_v, partialTicks) - z;
        if (this.func_177068_d().func_178634_b() && entity.isMountNode()) {
            Vec3d weightPos = entity.getWeightPos(partialTicks);
            GlStateManager.func_179140_f();
            GlStateManager.func_179084_k();
            GlStateManager.func_179090_x();
            GlStateManager.func_179131_c((float)0.5f, (float)0.0f, (float)0.0f, (float)1.0f);
            DebugHandlerClient.drawBoundingBox(new AxisAlignedBB(weightPos.field_72450_a - 0.1, weightPos.field_72448_b - 0.1, weightPos.field_72449_c - 0.1, weightPos.field_72450_a + 0.1, weightPos.field_72448_b + 0.1, weightPos.field_72449_c + 0.1).func_72317_d(-camPosX, -camPosY, -camPosZ));
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179098_w();
            GlStateManager.func_179147_l();
            GlStateManager.func_179145_e();
        }
        this.frustum.func_78547_a(camPosX, camPosY, camPosZ);
        Entity prevNode = entity.getPreviousNodeClient();
        if (prevNode instanceof EntityGrapplingHookNode && !this.field_76990_c.func_78713_a(prevNode).func_177071_a(prevNode, (ICamera)this.frustum, camPosX, camPosY, camPosZ)) {
            GlStateManager.func_179094_E();
            double renderOffsetX = RenderGrapplingHookNode.interpolate(prevNode.field_70142_S - entity.field_70142_S, prevNode.field_70165_t - entity.field_70165_t, partialTicks);
            double renderOffsetY = RenderGrapplingHookNode.interpolate(prevNode.field_70137_T - entity.field_70137_T, prevNode.field_70163_u - entity.field_70163_u, partialTicks);
            double renderOffsetZ = RenderGrapplingHookNode.interpolate(prevNode.field_70136_U - entity.field_70136_U, prevNode.field_70161_v - entity.field_70161_v, partialTicks);
            GlStateManager.func_179137_b((double)renderOffsetX, (double)renderOffsetY, (double)renderOffsetZ);
            this.renderConnection(prevNode, entity, tessellator, buffer, x, y, z, partialTicks);
            GlStateManager.func_179121_F();
        }
        if ((nextNode = entity.getNextNodeClient()) instanceof EntityGrapplingHookNode) {
            this.renderConnection(entity, nextNode, tessellator, buffer, x, y, z, partialTicks);
            double dx = RenderGrapplingHookNode.interpolate(entity.field_70142_S, entity.field_70165_t, partialTicks) - RenderGrapplingHookNode.interpolate(nextNode.field_70142_S, nextNode.field_70165_t, partialTicks);
            double dy = RenderGrapplingHookNode.interpolate(entity.field_70137_T, entity.field_70163_u, partialTicks) - RenderGrapplingHookNode.interpolate(nextNode.field_70137_T, nextNode.field_70163_u, partialTicks);
            double dz = RenderGrapplingHookNode.interpolate(entity.field_70136_U, entity.field_70161_v, partialTicks) - RenderGrapplingHookNode.interpolate(nextNode.field_70136_U, nextNode.field_70161_v, partialTicks);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            GlStateManager.func_179114_b((float)(-((float)Math.toDegrees(Math.atan2(dz, dx)))), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)Math.toDegrees(Math.atan2(Math.sqrt(dx * dx + dz * dz), -dy)) + 180.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            if (prevNode == null) {
                this.func_110776_a(TEXTURE_SHAMBLER);
                GlStateManager.func_179094_E();
                GlStateManager.func_179139_a((double)1.1, (double)1.1, (double)1.1);
                GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179137_b((double)0.0, (double)-1.0, (double)0.1);
                GlStateManager.func_179129_p();
                shamblerModel.renderTongueEnd(0.0625f);
                GlStateManager.func_179089_o();
                GlStateManager.func_179121_F();
            } else {
                this.func_110776_a(TextureMap.field_110575_b);
                GlStateManager.func_179140_f();
                GlStateManager.func_179094_E();
                GlStateManager.func_179139_a((double)0.25, (double)0.25, (double)0.25);
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)0.4, (double)0.0, (double)0.0);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                this.renderItem.func_181564_a(this.anglerTooth, ItemCameraTransforms.TransformType.FIXED);
                GlStateManager.func_179121_F();
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)-0.4, (double)0.0, (double)0.0);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                this.renderItem.func_181564_a(this.anglerTooth, ItemCameraTransforms.TransformType.FIXED);
                GlStateManager.func_179121_F();
                GlStateManager.func_179094_E();
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)0.4, (double)0.0, (double)0.0);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                this.renderItem.func_181564_a(this.anglerTooth, ItemCameraTransforms.TransformType.FIXED);
                GlStateManager.func_179121_F();
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)-0.4, (double)0.0, (double)0.0);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                this.renderItem.func_181564_a(this.anglerTooth, ItemCameraTransforms.TransformType.FIXED);
                GlStateManager.func_179121_F();
                GlStateManager.func_179121_F();
                GlStateManager.func_179145_e();
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179121_F();
            this.func_180548_c(entity);
        }
        GlStateManager.func_179121_F();
    }

    protected static double interpolate(double prev, double now, double partialTicks) {
        return prev + (now - prev) * partialTicks;
    }

    protected void renderConnection(Entity node1, Entity node2, Tessellator tessellator, BufferBuilder buffer, double x, double y, double z, float partialTicks) {
        if (node2 != null) {
            double camPosX = RenderGrapplingHookNode.interpolate(node1.field_70169_q - x, node1.field_70165_t - x, partialTicks);
            double camPosY = RenderGrapplingHookNode.interpolate(node1.field_70167_r - y, node1.field_70163_u - y, partialTicks);
            double camPosZ = RenderGrapplingHookNode.interpolate(node1.field_70166_s - z, node1.field_70161_v - z, partialTicks);
            double startX = x;
            double startY = y;
            double startZ = z;
            double endX = RenderGrapplingHookNode.interpolate(node2.field_70169_q - camPosX, node2.field_70165_t - camPosX, partialTicks);
            double endY = RenderGrapplingHookNode.interpolate(node2.field_70167_r - camPosY, node2.field_70163_u - camPosY, partialTicks);
            double endZ = RenderGrapplingHookNode.interpolate(node2.field_70166_s - camPosZ, node2.field_70161_v - camPosZ, partialTicks);
            if (node2 instanceof EntityGrapplingHookNode && ((EntityGrapplingHookNode)node2).isMountNode() && node2.func_184179_bs() != null) {
                Entity controller = node2.func_184179_bs();
                double yaw = controller instanceof EntityLivingBase ? RenderGrapplingHookNode.interpolate(((EntityLivingBase)controller).field_70760_ar, ((EntityLivingBase)controller).field_70761_aq, partialTicks) : RenderGrapplingHookNode.interpolate(controller.field_70126_B, controller.field_70177_z, partialTicks);
                EnumHand activeHand = EnumHand.MAIN_HAND;
                if (controller instanceof EntityLivingBase) {
                    activeHand = !((EntityLivingBase)controller).func_184586_b(EnumHand.OFF_HAND).func_190926_b() && ((EntityLivingBase)controller).func_184586_b(EnumHand.OFF_HAND).func_77973_b() instanceof ItemGrapplingHook ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND;
                }
                double rotX = 0.0;
                double rotZ = 0.0;
                if (activeHand == EnumHand.MAIN_HAND) {
                    rotX += -Math.cos(Math.toRadians(-yaw)) * 0.6;
                    rotZ += Math.sin(Math.toRadians(-yaw)) * 0.6;
                } else {
                    rotX += -Math.cos(Math.toRadians(-yaw)) * -0.6;
                    rotZ += Math.sin(Math.toRadians(-yaw)) * -0.6;
                }
                rotX += -Math.cos(Math.toRadians(-yaw + 90.0)) * 0.4;
                rotZ += Math.sin(Math.toRadians(-yaw + 90.0)) * 0.4;
                double yOffset = 0.0;
                if (controller instanceof EntityLivingBase && !((EntityLivingBase)controller).func_184586_b(activeHand).func_190926_b()) {
                    yOffset += 0.2;
                }
                if (activeHand == EnumHand.OFF_HAND) {
                    yOffset += 0.2;
                }
                Vec3d offset = new Vec3d(rotX, 1.1 + yOffset, rotZ);
                Vec3d weightPos = ((EntityGrapplingHookNode)node2).getWeightPos(partialTicks);
                double dx = RenderGrapplingHookNode.interpolate(node2.field_70142_S, node2.field_70165_t, partialTicks) - weightPos.field_72450_a;
                double dy = RenderGrapplingHookNode.interpolate(node2.field_70137_T, node2.field_70163_u, partialTicks) + (double)node2.field_70131_O - weightPos.field_72448_b;
                double dz = RenderGrapplingHookNode.interpolate(node2.field_70136_U, node2.field_70161_v, partialTicks) - weightPos.field_72449_c;
                float rotYaw = -((float)Math.toDegrees(Math.atan2(dz, dx)));
                float rotPitch = (float)Math.toDegrees(Math.atan2(Math.sqrt(dx * dx + dz * dz), -dy)) - 180.0f;
                float pitchMin = -30.0f;
                float pitchMax = 30.0f;
                float t = (rotPitch - pitchMin) / (pitchMax - pitchMin);
                rotPitch = pitchMin + (pitchMax - pitchMin) * (1.0f / (1.0f + (float)Math.pow(200.0, 0.5f - t)));
                RotationMatrix matrix = new RotationMatrix();
                matrix.setRotations(0.0f, -((float)Math.toRadians(yaw)), 0.0f);
                offset = offset.func_178787_e(matrix.transformVec(new Vec3d(activeHand == EnumHand.MAIN_HAND ? 0.6 : -0.6, 0.0, -0.4), Vec3d.field_186680_a));
                matrix.setRotations(0.0f, -((float)Math.toRadians(rotYaw)), 0.0f);
                offset = matrix.transformVec(offset, Vec3d.field_186680_a);
                matrix.setRotations(0.0f, 0.0f, (float)Math.toRadians(rotPitch));
                offset = matrix.transformVec(offset.func_72441_c(0.0, -1.4, 0.0), Vec3d.field_186680_a);
                matrix.setRotations(0.0f, (float)Math.toRadians(rotYaw), 0.0f);
                offset = matrix.transformVec(offset, Vec3d.field_186680_a);
                offset = offset.func_72441_c(0.0, 1.4, 0.0);
                endX = RenderGrapplingHookNode.interpolate(controller.field_70142_S - camPosX, controller.field_70165_t - camPosX, partialTicks) + offset.field_72450_a;
                endY = RenderGrapplingHookNode.interpolate(controller.field_70137_T - camPosY, controller.field_70163_u - camPosY, partialTicks) + offset.field_72448_b;
                endZ = RenderGrapplingHookNode.interpolate(controller.field_70136_U - camPosZ, controller.field_70161_v - camPosZ, partialTicks) + offset.field_72449_c;
            }
            double diffX = (float)(endX - startX);
            double diffY = (float)(endY - startY);
            double diffZ = (float)(endZ - startZ);
            GlStateManager.func_179098_w();
            GlStateManager.func_179140_f();
            GlStateManager.func_179129_p();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            ParticleBeam.buildBeam(x + diffX, y + diffY, z + diffZ, new Vec3d(-diffX, -diffY, -diffZ), 0.05f, 0.0f, 2.0f, ActiveRenderInfo.func_178808_b(), ActiveRenderInfo.func_178803_d(), ActiveRenderInfo.func_178805_e(), ActiveRenderInfo.func_178807_f(), ActiveRenderInfo.func_178809_c(), (vx, vy, vz, u, v) -> buffer.func_181662_b(vx, vy, vz).func_187315_a(u, v).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d());
            tessellator.func_78381_a();
            GlStateManager.func_179145_e();
            GlStateManager.func_179089_o();
        }
    }

    protected ResourceLocation getEntityTexture(EntityGrapplingHookNode entity) {
        return TEXTURE_ROPE;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerRenderPre(RenderPlayerEvent.Pre event) {
        EntityGrapplingHookNode node;
        Entity prevNode;
        GlStateManager.func_179094_E();
        EntityPlayer player = event.getEntityPlayer();
        Entity ridingEntity = player.func_184187_bx();
        if (ridingEntity instanceof EntityGrapplingHookNode && (prevNode = (node = (EntityGrapplingHookNode)ridingEntity).getPreviousNode()) != null) {
            float partialTicks = event.getPartialRenderTick();
            Vec3d weightPos = node.getWeightPos(partialTicks);
            double dx = RenderGrapplingHookNode.interpolate(node.field_70142_S, node.field_70165_t, partialTicks) - weightPos.field_72450_a;
            double dy = RenderGrapplingHookNode.interpolate(node.field_70137_T, node.field_70163_u, partialTicks) + (double)node.field_70131_O - weightPos.field_72448_b;
            double dz = RenderGrapplingHookNode.interpolate(node.field_70136_U, node.field_70161_v, partialTicks) - weightPos.field_72449_c;
            float yaw = -((float)Math.toDegrees(Math.atan2(dz, dx)));
            float pitch = (float)Math.toDegrees(Math.atan2(Math.sqrt(dx * dx + dz * dz), -dy)) - 180.0f;
            float pitchMin = -30.0f;
            float pitchMax = 30.0f;
            float t = (pitch - pitchMin) / (pitchMax - pitchMin);
            pitch = pitchMin + (pitchMax - pitchMin) * (1.0f / (1.0f + (float)Math.pow(200.0, 0.5f - t)));
            GlStateManager.func_179137_b((double)event.getX(), (double)event.getY(), (double)event.getZ());
            GlStateManager.func_179137_b((double)0.0, (double)1.4, (double)0.0);
            GlStateManager.func_179114_b((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)pitch, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)(-yaw), (float)0.0f, (float)1.0f, (float)0.0f);
            float bodyYaw = (float)RenderGrapplingHookNode.interpolate(player.field_70760_ar, player.field_70761_aq, partialTicks);
            EnumHand activeHand = !player.func_184586_b(EnumHand.OFF_HAND).func_190926_b() && player.func_184586_b(EnumHand.OFF_HAND).func_77973_b() instanceof ItemGrapplingHook ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND;
            GlStateManager.func_179114_b((float)(-bodyYaw), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)(activeHand == EnumHand.MAIN_HAND ? 0.6 : -0.6), (double)-1.4, (double)-0.4);
            GlStateManager.func_179114_b((float)bodyYaw, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)(-event.getX()), (double)(-event.getY()), (double)(-event.getZ()));
            player.field_184622_au = activeHand;
            player.field_70733_aJ = 0.12f;
        }
    }

    @SubscribeEvent
    public static void onPlayerRenderPost(RenderPlayerEvent.Post event) {
        GlStateManager.func_179121_F();
    }
}

