/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.entity.layer.LayerOverlay;
import thebetweenlands.client.render.model.entity.ModelCaveFish;
import thebetweenlands.common.entity.mobs.EntityCaveFish;

@SideOnly(value=Side.CLIENT)
public class RenderCaveFish
extends RenderLiving<EntityCaveFish> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("thebetweenlands:textures/entity/cave_fish.png");
    public static final ModelCaveFish CAVE_FISH_MODEL = new ModelCaveFish();

    public RenderCaveFish(RenderManager rendermanagerIn) {
        super(rendermanagerIn, (ModelBase)CAVE_FISH_MODEL, 0.5f);
        this.func_177094_a(new LayerOverlay<EntityCaveFish>((RenderLivingBase)this, new ResourceLocation("thebetweenlands:textures/entity/cave_fish_leader_glow.png")){

            public void doRenderLayer(EntityCaveFish entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
                if (entity.isLeader()) {
                    super.func_177141_a(entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
                }
            }
        }.setGlow(true));
    }

    protected void preRenderCallback(EntityCaveFish entitylivingbaseIn, float partialTickTime) {
        if (!entitylivingbaseIn.isLeader()) {
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        }
        GlStateManager.func_179109_b((float)0.0f, (float)0.5f, (float)0.0f);
        float smoothedPitch = entitylivingbaseIn.field_70127_C + (entitylivingbaseIn.field_70125_A - entitylivingbaseIn.field_70127_C) * partialTickTime;
        GlStateManager.func_179114_b((float)smoothedPitch, (float)1.0f, (float)0.0f, (float)0.0f);
    }

    protected void renderModel(EntityCaveFish entitylivingbaseIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        GlStateManager.func_179089_o();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        super.func_77036_a((EntityLivingBase)entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
        GlStateManager.func_179084_k();
        GlStateManager.func_179129_p();
    }

    protected ResourceLocation getEntityTexture(EntityCaveFish entity) {
        return TEXTURE;
    }
}

