/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.entity.layer.LayerOverlay;
import thebetweenlands.client.render.model.entity.ModelBarrishee;
import thebetweenlands.client.render.shader.LightSource;
import thebetweenlands.client.render.shader.ShaderHelper;
import thebetweenlands.common.entity.mobs.EntityBarrishee;

@SideOnly(value=Side.CLIENT)
public class RenderBarrishee
extends RenderLiving<EntityBarrishee> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("thebetweenlands:textures/entity/barrishee.png");
    public int fudge = 0;

    public RenderBarrishee(RenderManager renderManagerIn) {
        super(renderManagerIn, (ModelBase)new ModelBarrishee(), 1.0f);
        this.func_177094_a(new LayerOverlay(this, new ResourceLocation("thebetweenlands:textures/entity/barrishee_face.png")).setGlow(true));
    }

    protected void preRenderCallback(EntityBarrishee entity, float partialTickTime) {
        if (entity.isAmbushSpawn() || entity.isSlamming()) {
            if (entity.isScreaming()) {
                GlStateManager.func_179109_b((float)0.0f, (float)(-0.5f + entity.standingAngle * 0.5f - (float)this.getTimerFudge(entity) * 0.00625f - 0.0625f), (float)0.0f);
                this.lightUpStuff(entity, partialTickTime);
            } else {
                GlStateManager.func_179109_b((float)0.0f, (float)(-0.5f + entity.standingAngle * 0.5f), (float)0.0f);
            }
        } else if (entity.isScreaming()) {
            GlStateManager.func_179109_b((float)0.0f, (float)(0.0f - (float)this.getTimerFudge(entity) * 0.00625f - 0.0625f), (float)0.0f);
            this.lightUpStuff(entity, partialTickTime);
        }
    }

    public void lightUpStuff(EntityBarrishee entity, float partialTickTime) {
        if (ShaderHelper.INSTANCE.isWorldShaderActive()) {
            ShaderHelper.INSTANCE.require();
            ShaderHelper.INSTANCE.getWorldShader().addLight(new LightSource(entity.field_70165_t, entity.field_70163_u + 1.25, entity.field_70161_v, ((float)this.fudge + partialTickTime) / 2.0f + 1.0f, 4.0f, 1.6f, 0.0f));
            ShaderHelper.INSTANCE.getWorldShader().addLight(new LightSource(entity.field_70165_t, entity.field_70163_u + 1.25, entity.field_70161_v, ((float)this.getTimerFudge(entity) + partialTickTime) / 2.0f + 0.6f, 1.6470588f, 0.40784314f, 0.0f));
        }
    }

    public int getTimerFudge(EntityBarrishee entity) {
        if (entity.getScreamTimer() >= 20 && entity.getScreamTimer() <= 30) {
            this.fudge = entity.getScreamTimer() - 20;
        }
        if (entity.getScreamTimer() > 30 && entity.getScreamTimer() < 40) {
            this.fudge = 10;
        }
        if (entity.getScreamTimer() >= 40) {
            this.fudge = -entity.getScreamTimer() + 50;
        }
        return this.fudge;
    }

    protected ResourceLocation getEntityTexture(EntityBarrishee entity) {
        return TEXTURE;
    }
}

