/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.model.entity.ModelAnadia;
import thebetweenlands.common.entity.mobs.EntityAnadia;

@SideOnly(value=Side.CLIENT)
public class RenderAnadia
extends RenderLiving<EntityAnadia> {
    private static final ResourceLocation[] TEXTURE_1 = new ResourceLocation[]{new ResourceLocation("thebetweenlands:textures/entity/anadia_1_smoked.png"), new ResourceLocation("thebetweenlands:textures/entity/anadia_1_rotten.png"), new ResourceLocation("thebetweenlands:textures/entity/anadia_1_base.png"), new ResourceLocation("thebetweenlands:textures/entity/anadia_1_silver.png"), new ResourceLocation("thebetweenlands:textures/entity/anadia_1_purple.png"), new ResourceLocation("thebetweenlands:textures/entity/anadia_1_green.png")};
    private static final ResourceLocation[] TEXTURE_2 = new ResourceLocation[]{new ResourceLocation("thebetweenlands:textures/entity/anadia_2_smoked.png"), new ResourceLocation("thebetweenlands:textures/entity/anadia_2_rotten.png"), new ResourceLocation("thebetweenlands:textures/entity/anadia_2_base.png"), new ResourceLocation("thebetweenlands:textures/entity/anadia_2_silver.png"), new ResourceLocation("thebetweenlands:textures/entity/anadia_2_purple.png"), new ResourceLocation("thebetweenlands:textures/entity/anadia_2_green.png")};
    private static final ResourceLocation[] TEXTURE_3 = new ResourceLocation[]{new ResourceLocation("thebetweenlands:textures/entity/anadia_3_smoked.png"), new ResourceLocation("thebetweenlands:textures/entity/anadia_3_rotten.png"), new ResourceLocation("thebetweenlands:textures/entity/anadia_3_base.png"), new ResourceLocation("thebetweenlands:textures/entity/anadia_3_silver.png"), new ResourceLocation("thebetweenlands:textures/entity/anadia_3_purple.png"), new ResourceLocation("thebetweenlands:textures/entity/anadia_3_green.png")};
    public static final ModelAnadia ANADIA_MODEL = new ModelAnadia();

    public RenderAnadia(RenderManager manager) {
        super(manager, (ModelBase)ANADIA_MODEL, 0.5f);
    }

    protected ResourceLocation getEntityTexture(EntityAnadia entity) {
        return TEXTURE_1[2];
    }

    protected void applyRotations(EntityAnadia entity, float ageInTicks, float rotationYaw, float partialTicks) {
        float smoothedPitch = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partialTicks;
        float smoothedYaw = entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * partialTicks;
        GlStateManager.func_179114_b((float)(180.0f - smoothedYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        float scale = entity.getFishSize();
        GlStateManager.func_179109_b((float)0.0f, (float)(0.4f * scale), (float)0.0f);
        GlStateManager.func_179114_b((float)(-smoothedPitch), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)(-0.4f * scale), (float)0.0f);
        if (entity.field_70725_aQ > 0) {
            float f = ((float)entity.field_70725_aQ + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = MathHelper.func_76129_c((float)f)) > 1.0f) {
                f = 1.0f;
            }
            GlStateManager.func_179114_b((float)(f * this.func_77037_a((EntityLivingBase)entity)), (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    protected void preRenderCallback(EntityAnadia entity, float partialTickTime) {
        float scale = entity.getFishSize();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
    }

    protected void renderModel(EntityAnadia entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        boolean isTransparent;
        boolean isVisible = this.func_193115_c((EntityLivingBase)entity);
        boolean bl = isTransparent = !isVisible && !entity.func_98034_c((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (isVisible || isTransparent) {
            if (!this.func_180548_c((Entity)entity)) {
                return;
            }
            if (isTransparent) {
                GlStateManager.func_187408_a((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
            }
            GlStateManager.func_179089_o();
            switch (entity.getHeadType()) {
                default: {
                    this.func_110776_a(RenderAnadia.getTextureForColor(TEXTURE_1, entity.getFishColour()));
                    ANADIA_MODEL.renderHead(entity.getHeadType(), 0.0625f);
                    break;
                }
                case HEAD_2: {
                    this.func_110776_a(RenderAnadia.getTextureForColor(TEXTURE_2, entity.getFishColour()));
                    ANADIA_MODEL.renderHead(entity.getHeadType(), 0.0625f);
                    break;
                }
                case HEAD_3: {
                    this.func_110776_a(RenderAnadia.getTextureForColor(TEXTURE_3, entity.getFishColour()));
                    ANADIA_MODEL.renderHead(entity.getHeadType(), 0.0625f);
                }
            }
            switch (entity.getBodyType()) {
                default: {
                    this.func_110776_a(RenderAnadia.getTextureForColor(TEXTURE_1, entity.getFishColour()));
                    ANADIA_MODEL.renderBody(entity.getBodyType(), 0.0625f);
                    break;
                }
                case BODY_2: {
                    this.func_110776_a(RenderAnadia.getTextureForColor(TEXTURE_2, entity.getFishColour()));
                    ANADIA_MODEL.renderBody(entity.getBodyType(), 0.0625f);
                    break;
                }
                case BODY_3: {
                    this.func_110776_a(RenderAnadia.getTextureForColor(TEXTURE_3, entity.getFishColour()));
                    ANADIA_MODEL.renderBody(entity.getBodyType(), 0.0625f);
                }
            }
            switch (entity.getTailType()) {
                default: {
                    this.func_110776_a(RenderAnadia.getTextureForColor(TEXTURE_1, entity.getFishColour()));
                    ANADIA_MODEL.renderTail(entity.getTailType(), 0.0625f);
                    break;
                }
                case TAIL_2: {
                    this.func_110776_a(RenderAnadia.getTextureForColor(TEXTURE_2, entity.getFishColour()));
                    ANADIA_MODEL.renderTail(entity.getTailType(), 0.0625f);
                    break;
                }
                case TAIL_3: {
                    this.func_110776_a(RenderAnadia.getTextureForColor(TEXTURE_3, entity.getFishColour()));
                    ANADIA_MODEL.renderTail(entity.getTailType(), 0.0625f);
                }
            }
            GlStateManager.func_179129_p();
            if (isTransparent) {
                GlStateManager.func_187440_b((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
            }
        }
    }

    private static ResourceLocation getTextureForColor(ResourceLocation[] textures, EntityAnadia.EnumAnadiaColor color) {
        switch (color) {
            default: {
                return textures[2];
            }
            case SMOKED: {
                return textures[0];
            }
            case ROTTEN: {
                return textures[1];
            }
            case BASE: {
                return textures[2];
            }
            case SILVER: {
                return textures[3];
            }
            case PURPLE: {
                return textures[4];
            }
            case GREEN: 
        }
        return textures[5];
    }
}

