/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.gui;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import thebetweenlands.client.handler.TextureStitchHandler;
import thebetweenlands.client.render.particle.entity.ParticleSwarm;
import thebetweenlands.client.render.sprite.TextureAnimation;

public class GuiCrawler
extends Gui {
    public float updateCounter = 0.0f;
    private float prevPosX = 0.0f;
    private float prevPosY = 0.0f;
    private float posX = 0.0f;
    private float posY = 0.0f;
    private float motionY = 0.0f;
    private float motionX = 0.0f;
    private Random rand;
    private float rotateBias;
    private TextureAnimation animation;
    private float rotation;
    private float prevHurtRotation;
    private float hurtRotation;
    private float hurtTint;
    private float alpha = 1.0f;
    private int hurtDir;
    private float scale;
    public boolean dead;
    public boolean dropping;

    public GuiCrawler(float x, float y, float mX, float mY) {
        this.posX = this.prevPosX = x;
        this.posY = this.prevPosY = y;
        this.motionX = mX;
        this.motionY = mY;
        this.rand = new Random();
        this.hurtDir = this.rand.nextBoolean() ? 1 : -1;
        this.animation = new TextureAnimation();
        TextureStitchHandler.Frame[][] sprites = ParticleSwarm.SPRITES.getSprites();
        TextureStitchHandler.Frame[] frames = sprites[this.rand.nextInt(sprites.length)];
        this.animation.setFrames(frames);
        ResourceLocation location = frames[0].getLocation();
        if (location instanceof ParticleSwarm.ResourceLocationWithScale) {
            this.scale = ((ParticleSwarm.ResourceLocationWithScale)location).scale;
        }
    }

    public void update(int hurtTicks) {
        this.prevHurtRotation = this.hurtRotation;
        if (hurtTicks > 0) {
            this.hurtRotation = (float)Math.pow((float)hurtTicks / 10.0f - 0.5f, 5.0) * 16.0f * (float)Math.PI;
            this.hurtTint = (float)hurtTicks / 10.0f;
        } else {
            this.hurtRotation = 0.0f;
            this.hurtTint = 0.0f;
        }
        this.animation.update();
        this.updateCounter += 1.0f;
        if (this.updateCounter > 80.0f) {
            this.dead = true;
        } else if (this.updateCounter > 70.0f) {
            this.alpha = (80.0f - this.updateCounter) / 10.0f;
        }
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.posY += this.motionY;
        this.posX += this.motionX;
        double speed = MathHelper.func_76129_c((float)(this.motionX * this.motionX + this.motionY * this.motionY));
        Vec3d normal = new Vec3d(0.0, 0.0, 1.0);
        Vec3d motion = new Vec3d((double)this.motionX, (double)this.motionY, 0.0);
        Vec3d side = motion.func_72432_b().func_72431_c(normal);
        if (this.rand.nextInt(10) == 0) {
            this.rotateBias = (this.rand.nextFloat() - 0.5f) * 0.1f;
        }
        Vec3d newMotion = motion.func_178787_e(side.func_186678_a(speed * (double)((this.rand.nextFloat() - 0.5f) * 0.5f + this.rotateBias))).func_72432_b().func_186678_a(speed);
        this.motionX = (float)newMotion.field_72450_a;
        this.motionY = (float)newMotion.field_72448_b;
        this.rotation = (float)MathHelper.func_181159_b((double)this.motionY, (double)this.motionX) + 1.5707964f;
        if (this.dropping) {
            this.motionY += 8.0f;
            this.motionX *= 0.5f;
        }
    }

    public float getPosX() {
        return this.posX;
    }

    public float getPosY() {
        return this.posY;
    }

    public void drawCrawler(Minecraft minecraft, BufferBuilder vertexbuffer, float partialTicks) {
        float interpX = this.prevPosX + (this.posX - this.prevPosX) * partialTicks;
        float interpY = this.prevPosY + (this.posY - this.prevPosY) * partialTicks;
        TextureAtlasSprite sprite = this.animation.getCurrentSprite();
        this.drawTexturedModalRectWithColor(vertexbuffer, interpX, interpY, sprite.func_94209_e(), sprite.func_94206_g(), sprite.func_94212_f(), sprite.func_94210_h(), 16.0f * this.scale, 16.0f * this.scale, this.rotation + (float)this.hurtDir * (this.prevHurtRotation + (this.hurtRotation - this.prevHurtRotation) * partialTicks), this.alpha);
    }

    public void drawTexturedModalRectWithColor(BufferBuilder vertexbuffer, float x, float y, float minU, float minV, float maxU, float maxV, float width, float height, float rot, float alpha) {
        float minX = x;
        float maxX = x + width;
        float minY = y;
        float maxY = y + height;
        float cos = (float)Math.cos(rot);
        float sin = (float)Math.sin(rot);
        float cx = x + width * 0.5f;
        float cy = y + height * 0.5f;
        float nnx = (minX - cx) * cos - (minY - cy) * sin + cx;
        float nny = (minX - cx) * sin + (minY - cy) * cos + cy;
        float ppx = (maxX - cx) * cos - (maxY - cy) * sin + cx;
        float ppy = (maxX - cx) * sin + (maxY - cy) * cos + cy;
        float mpx = (minX - cx) * cos - (maxY - cy) * sin + cx;
        float mpy = (minX - cx) * sin + (maxY - cy) * cos + cy;
        float pmx = (maxX - cx) * cos - (minY - cy) * sin + cx;
        float pmy = (maxX - cx) * sin + (minY - cy) * cos + cy;
        float gb = 1.0f - this.hurtTint;
        vertexbuffer.func_181662_b((double)mpx, (double)mpy, (double)this.field_73735_i).func_187315_a((double)minU, (double)maxV).func_181666_a(1.0f, gb, gb, alpha).func_181675_d();
        vertexbuffer.func_181662_b((double)ppx, (double)ppy, (double)this.field_73735_i).func_187315_a((double)maxU, (double)maxV).func_181666_a(1.0f, gb, gb, alpha).func_181675_d();
        vertexbuffer.func_181662_b((double)pmx, (double)pmy, (double)this.field_73735_i).func_187315_a((double)maxU, (double)minV).func_181666_a(1.0f, gb, gb, alpha).func_181675_d();
        vertexbuffer.func_181662_b((double)nnx, (double)nny, (double)this.field_73735_i).func_187315_a((double)minU, (double)minV).func_181666_a(1.0f, gb, gb, alpha).func_181675_d();
    }
}

