/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.audio.ambience.list;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import thebetweenlands.client.audio.ambience.AmbienceLayer;
import thebetweenlands.client.audio.ambience.AmbienceType;
import thebetweenlands.common.registries.AmbienceRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;
import thebetweenlands.common.world.storage.location.EnumLocationType;
import thebetweenlands.common.world.storage.location.LocationStorage;

public class FloatingIslandAmbienceType
extends AmbienceType {
    private float volume;

    protected float getSoundStrength() {
        EntityPlayer player = this.getPlayer();
        BetweenlandsWorldStorage worldStorage = BetweenlandsWorldStorage.forWorld(player.field_70170_p);
        List<LocationStorage> locations = worldStorage.getLocalStorageHandler().getLocalStorages(LocationStorage.class, player.func_174813_aQ().func_186662_g(8.0), location -> location.getType() == EnumLocationType.FLOATING_ISLAND);
        if (!locations.isEmpty()) {
            double minDist = Double.MAX_VALUE;
            for (LocationStorage location2 : locations) {
                AxisAlignedBB aabb = location2.getBoundingBox();
                double px = MathHelper.func_151237_a((double)player.field_70165_t, (double)aabb.field_72340_a, (double)aabb.field_72336_d);
                double py = MathHelper.func_151237_a((double)player.field_70163_u, (double)aabb.field_72338_b, (double)aabb.field_72337_e);
                double pz = MathHelper.func_151237_a((double)player.field_70161_v, (double)aabb.field_72339_c, (double)aabb.field_72334_f);
                double dx = player.field_70165_t - px;
                double dy = player.field_70163_u - py;
                double dz = player.field_70161_v - pz;
                double dst = MathHelper.func_76133_a((double)(dx * dx + dy * dy + dz * dz));
                minDist = Math.min(minDist, dst);
            }
            return 1.0f - Math.min(1.0f, (float)minDist / 8.0f);
        }
        return 0.0f;
    }

    @Override
    public boolean isActive() {
        this.volume = this.getSoundStrength();
        return this.volume > 0.01f;
    }

    @Override
    public float getVolume() {
        return this.volume;
    }

    @Override
    public AmbienceLayer getAmbienceLayer() {
        return AmbienceRegistry.BASE_LAYER;
    }

    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public SoundCategory getCategory() {
        return SoundCategory.AMBIENT;
    }

    @Override
    public SoundEvent getSound() {
        return SoundRegistry.AMBIENT_FLOATING_ISLAND;
    }
}

