/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol.modifiers;

import com.xcompwiz.mystcraft.api.symbol.ModifierUtils;
import com.xcompwiz.mystcraft.api.world.AgeDirector;
import com.xcompwiz.mystcraft.symbol.SymbolBase;
import net.minecraft.util.ResourceLocation;

public class SymbolAngle
extends SymbolBase {
    private final float value;
    private final String display;

    public SymbolAngle(ResourceLocation identifier, float value, String display) {
        super(identifier);
        this.value = value;
        this.display = display;
    }

    @Override
    public boolean generatesConfigOption() {
        return true;
    }

    @Override
    public void registerLogic(AgeDirector controller, long seed) {
        Float value = Float.valueOf(this.value);
        Number prev = controller.popModifier("angle").asNumber();
        if (prev != null) {
            value = Float.valueOf(ModifierUtils.averageAngles(prev.floatValue(), value.floatValue()));
        }
        if (value.floatValue() >= 360.0f) {
            value = Float.valueOf(value.floatValue() - 360.0f);
        }
        controller.setModifier("angle", value);
    }

    @Override
    public String generateLocalizedName() {
        return this.display + " Direction";
    }
}

