/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.instability.bonus;

import com.xcompwiz.mystcraft.instability.bonus.EventManager;
import com.xcompwiz.mystcraft.instability.bonus.InstabilityBonusManager;
import com.xcompwiz.mystcraft.network.NetworkUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class PlayerKilledBonus
implements InstabilityBonusManager.IInstabilityBonus,
EventManager.IOnEntityDeath,
EventManager.IOnPlayerChangedDimension,
EventManager.IOnPlayerLoggedIn {
    private InstabilityBonusManager bonusmanager;
    private String name;
    private int max;
    private int min;
    private float decayrate;
    private float current;
    private String playername;
    private int dimensionid;

    public PlayerKilledBonus(InstabilityBonusManager bonusmanager, Integer dimensionid, String playername, Integer max, Float decayrate) {
        this.bonusmanager = bonusmanager;
        this.current = 0.0f;
        this.playername = playername;
        this.max = max;
        this.min = 0;
        this.decayrate = decayrate.floatValue();
        this.dimensionid = dimensionid;
        this.name = "Player Killed: " + playername;
        EventManager eventmgr = EventManager.get();
        eventmgr.register(this);
        eventmgr.register(this);
        eventmgr.register(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getValue() {
        return -((int)this.current);
    }

    @Override
    public void tick(World world) {
        this.current = Math.max((float)this.min, this.current - this.decayrate);
    }

    @Override
    public void onEntityDeath(LivingDeathEvent event) {
        if (event.getEntity().field_71093_bK == this.dimensionid && event.getEntity().func_70005_c_().equals(this.playername)) {
            if (event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof EntityPlayer) {
                this.current = this.max;
                this.announce("instability.bonus.death", this.playername, event.getSource().func_76346_g().func_70005_c_());
            } else {
                this.current = Math.max((float)(this.max / 2), this.current);
                this.announce("instability.bonus.death.partial", this.playername);
            }
        }
    }

    @Override
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player.field_71093_bK == this.dimensionid && event.player.func_70005_c_().equals(this.playername)) {
            this.announce("instability.bonus.death.alert", this.playername);
        }
    }

    @Override
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.toDim == this.dimensionid && event.player.func_70005_c_().equals(this.playername)) {
            this.announce("instability.bonus.death.alert", this.playername);
        }
    }

    private void announce(String string, Object ... args) {
        if (!this.bonusmanager.isInstabilityEnabled()) {
            return;
        }
        TextComponentTranslation chatcomponent = new TextComponentTranslation(string, args);
        NetworkUtils.sendMessageToPlayersInWorld((ITextComponent)chatcomponent, this.dimensionid);
    }
}

