/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.imc;

import com.google.common.collect.ImmutableList;
import com.xcompwiz.mystcraft.imc.IMCBlacklistFluid;
import com.xcompwiz.mystcraft.imc.IMCBlacklistSymbol;
import com.xcompwiz.mystcraft.imc.IMCBlockInstability;
import com.xcompwiz.mystcraft.imc.IMCFluidData;
import com.xcompwiz.mystcraft.imc.IMCMeteorBlock;
import com.xcompwiz.mystcraft.logging.LoggerUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class IMCHandler {
    private static Map<String, IMCProcessor> processors = new HashMap<String, IMCProcessor>();

    private static void registerProcessor(String key, IMCProcessor processor) {
        processors.put(key.toLowerCase(), processor);
    }

    public static void process(ImmutableList<FMLInterModComms.IMCMessage> messages) {
        for (FMLInterModComms.IMCMessage message : messages) {
            String key = message.key.toLowerCase();
            IMCProcessor process = processors.get(key);
            if (process == null) {
                LoggerUtils.error("IMC message '%s' from [%s] unrecognized", key, message.getSender());
                continue;
            }
            try {
                process.process(message);
            }
            catch (Exception e) {
                LoggerUtils.error("Failed to process IMC message '%s' from [%s]", key, message.getSender());
                e.printStackTrace();
            }
        }
    }

    static {
        IMCHandler.registerProcessor("blockinstability", new IMCBlockInstability());
        IMCHandler.registerProcessor("blacklistfluid", new IMCBlacklistFluid());
        IMCHandler.registerProcessor("blacklist", new IMCBlacklistSymbol());
        IMCHandler.registerProcessor("fluidsymboldata", new IMCFluidData());
        IMCHandler.registerProcessor("meteorblock", new IMCMeteorBlock());
    }

    public static interface IMCProcessor {
        public void process(FMLInterModComms.IMCMessage var1);
    }
}

