/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.effects;

import com.xcompwiz.mystcraft.api.instability.InstabilityDirector;
import com.xcompwiz.mystcraft.api.world.logic.IEnvironmentalEffect;
import com.xcompwiz.mystcraft.block.BlockDecay;
import com.xcompwiz.mystcraft.data.ModBlocks;
import com.xcompwiz.mystcraft.instability.decay.DecayHandler;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class EffectDecayBasic
implements IEnvironmentalEffect {
    private InstabilityDirector controller;
    private int updateLCG;
    private int maxscore = 1000000;
    private DecayHandler.DecayType decayType;
    private int min;
    private Integer max;
    private Set<Material> bannedmats = new HashSet<Material>();

    public EffectDecayBasic(InstabilityDirector controller, DecayHandler.DecayType type, int min, Integer max) {
        this.controller = controller;
        this.updateLCG = new Random().nextInt();
        this.decayType = type;
        this.min = min;
        this.max = max;
    }

    public void banMaterial(Material material) {
        this.bannedmats.add(material);
    }

    protected void placeBlock(World world, BlockPos pos, int minY, Integer maxY, DecayHandler.DecayType type) {
        if (maxY == null && (maxY = Integer.valueOf(world.func_189649_b(pos.func_177958_n(), pos.func_177952_p()))) <= minY) {
            maxY = world.field_73011_w.func_76557_i();
        }
        if (maxY < minY) {
            return;
        }
        pos = maxY == minY ? new BlockPos(pos.func_177958_n(), minY, pos.func_177952_p()) : new BlockPos(pos.func_177958_n(), pos.func_177956_o() % (maxY - minY) + minY, pos.func_177952_p());
        Material material = world.func_180495_p(pos).func_185904_a();
        while (this.bannedmats.contains(material)) {
            if ((pos = pos.func_177977_b()).func_177956_o() < minY) {
                return;
            }
            material = world.func_180495_p(pos).func_185904_a();
        }
        world.func_180501_a(pos, ModBlocks.decay.func_176223_P().func_177226_a(BlockDecay.DECAY_META, (Comparable)((Object)type)), 2);
    }

    @Override
    public void tick(World worldObj, Chunk chunk) {
        int chunkX = chunk.field_76635_g * 16;
        int chunkZ = chunk.field_76647_h * 16;
        int score = this.controller.getInstabilityScore();
        if (worldObj.field_73012_v.nextInt(this.maxscore) < score) {
            this.updateLCG = this.updateLCG * 3 + 1013904223;
            int coords = this.updateLCG >> 2;
            int x = chunkX + (coords & 0xF);
            int z = chunkZ + (coords >> 8 & 0xF);
            int y = coords >> 16 & 0xFF;
            this.placeBlock(worldObj, new BlockPos(x, y, z), this.min, this.max, this.decayType);
        }
    }
}

