/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.data;

import com.xcompwiz.mystcraft.api.util.Color;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class InkEffects {
    private static final HashMap<String, Color> colormap = new HashMap();
    private static Map<ItemStack, Map<String, Float>> itemstack_bindings = new TreeMap<ItemStack, Map<String, Float>>(new CompareItemStack());
    private static Map<String, Map<String, Float>> oredict_bindings = new HashMap<String, Map<String, Float>>();
    private static Map<Item, Map<String, Float>> itemId_bindings = new HashMap<Item, Map<String, Float>>();

    public static Set<String> getProperties() {
        return colormap.keySet();
    }

    public static void registerProperty(String key, Color color) {
        colormap.put(key, color);
    }

    public static Color getPropertyColor(String key) {
        return colormap.get(key);
    }

    public static String getLocalizedName(String property) {
        return I18n.func_135052_a((String)InkEffects.getUnlocalizedName(property), (Object[])new Object[0]);
    }

    public static String getUnlocalizedName(String property) {
        return "linkeffect." + property.replaceAll(" ", "").toLowerCase() + ".name";
    }

    public static Map<String, Float> getItemEffects(ItemStack itemstack) {
        int[] ids;
        ItemStack clone = itemstack.func_77946_l();
        clone.func_190920_e(1);
        Map<String, Float> map = itemstack_bindings.get(clone);
        for (int id : ids = OreDictionary.getOreIDs((ItemStack)itemstack)) {
            if (map != null) continue;
            map = oredict_bindings.get(OreDictionary.getOreName((int)id));
        }
        if (map == null) {
            map = itemId_bindings.get(itemstack.func_77973_b());
        }
        if (map == null) {
            return null;
        }
        return Collections.unmodifiableMap(map);
    }

    private static void addPropertyToMap(Map<String, Float> itemmap, String property, float probability) {
        Float f = itemmap.get(property);
        if (f != null) {
            probability += f.floatValue();
        }
        itemmap.put(property, Float.valueOf(probability));
        float total = 0.0f;
        for (Map.Entry<String, Float> entry : itemmap.entrySet()) {
            total += entry.getValue().floatValue();
        }
        if (total > 1.0f) {
            throw new RuntimeException("ERROR: Total of all ink property probabilities from an item cannot exceed 1!");
        }
    }

    public static void addPropertyToItem(ItemStack itemstack, String property, float probability) {
        itemstack = itemstack.func_77946_l();
        itemstack.func_190920_e(1);
        Map<String, Float> itemmap = itemstack_bindings.get(itemstack);
        if (itemmap == null) {
            itemmap = new HashMap<String, Float>();
            itemstack_bindings.put(itemstack, itemmap);
        }
        InkEffects.addPropertyToMap(itemmap, property, probability);
    }

    public static void addPropertyToItem(String name, String property, float probability) {
        Map<String, Float> itemmap = oredict_bindings.get(name);
        if (itemmap == null) {
            itemmap = new HashMap<String, Float>();
            oredict_bindings.put(name, itemmap);
        }
        InkEffects.addPropertyToMap(itemmap, property, probability);
    }

    public static void addPropertyToItem(Item item, String property, float probability) {
        Map<String, Float> itemmap = itemId_bindings.get(item);
        if (itemmap == null) {
            itemmap = new HashMap<String, Float>();
            itemId_bindings.put(item, itemmap);
        }
        InkEffects.addPropertyToMap(itemmap, property, probability);
    }

    public static void init() {
        InkEffects.registerProperty("Intra Linking", new Color(0.0f, 1.0f, 0.0f));
        InkEffects.registerProperty("Intra Linking Only", new Color(1.0f, 1.0f, 1.0f));
        InkEffects.registerProperty("Generate Platform", new Color(0.5f, 0.5f, 0.5f));
        InkEffects.registerProperty("Maintain Momentum", new Color(0.0f, 0.0f, 1.0f));
        InkEffects.registerProperty("Disarm", new Color(1.0f, 0.0f, 0.0f));
        InkEffects.registerProperty("Relative", new Color(0.6f, 0.0f, 0.6f));
        InkEffects.addPropertyToItem(new ItemStack(Items.field_151016_H), "Disarm", 0.2f);
        InkEffects.addPropertyToItem(new ItemStack(Items.field_151009_A), "Disarm", 0.05f);
        InkEffects.addPropertyToItem(new ItemStack(Items.field_151119_aD), "Generate Platform", 0.25f);
        InkEffects.addPropertyToItem(new ItemStack(Items.field_151062_by), "Intra Linking", 0.15f);
        InkEffects.addPropertyToItem("dyeBlack", "", 0.5f);
        InkEffects.addPropertyToItem(new ItemStack(Items.field_151079_bi), "Intra Linking", 0.15f);
        InkEffects.addPropertyToItem(new ItemStack(Items.field_151079_bi), "Disarm", 0.15f);
        InkEffects.addPropertyToItem(new ItemStack(Items.field_151008_G), "Maintain Momentum", 0.15f);
        InkEffects.addPropertyToItem(Items.field_151059_bz, "Disarm", 0.25f);
        InkEffects.addPropertyToItem("dustBrass", "Disarm", 0.15f);
        InkEffects.addPropertyToItem("dustBronze", "Disarm", 0.15f);
        InkEffects.addPropertyToItem("dustTin", "Generate Platform", 0.1f);
        InkEffects.addPropertyToItem("dustTin", "Intra Linking", 0.1f);
        InkEffects.addPropertyToItem("dustIron", "Generate Platform", 0.15f);
        InkEffects.addPropertyToItem("dustIron", "Intra Linking", 0.15f);
        InkEffects.addPropertyToItem("dustLead", "Disarm", 0.2f);
        InkEffects.addPropertyToItem("dustLead", "Intra Linking", 0.2f);
        InkEffects.addPropertyToItem("dustSilver", "Generate Platform", 0.2f);
        InkEffects.addPropertyToItem("dustSilver", "Intra Linking", 0.2f);
        InkEffects.addPropertyToItem("dustDiamond", "Intra Linking", 0.25f);
        InkEffects.addPropertyToItem("dustDiamond", "Maintain Momentum", 0.1f);
        InkEffects.addPropertyToItem("dustDiamond", "Generate Platform", 0.1f);
        InkEffects.addPropertyToItem("dustGold", "Intra Linking", 0.25f);
        InkEffects.addPropertyToItem("dustGold", "Generate Platform", 0.1f);
        InkEffects.addPropertyToItem("dustGold", "Disarm", 0.1f);
    }

    public static class CompareItemStack
    implements Comparator<ItemStack> {
        @Override
        public int compare(ItemStack paramT1, ItemStack paramT2) {
            if (paramT1 == paramT2) {
                return 0;
            }
            if (ItemStack.func_77989_b((ItemStack)paramT1, (ItemStack)paramT2)) {
                return 0;
            }
            if (Item.func_150891_b((Item)paramT1.func_77973_b()) < Item.func_150891_b((Item)paramT2.func_77973_b())) {
                return -1;
            }
            if (Item.func_150891_b((Item)paramT1.func_77973_b()) > Item.func_150891_b((Item)paramT2.func_77973_b())) {
                return 1;
            }
            if (paramT1.func_77952_i() < paramT2.func_77952_i()) {
                return -1;
            }
            if (paramT1.func_77952_i() > paramT2.func_77952_i()) {
                return 1;
            }
            if (paramT1.func_190916_E() < paramT2.func_190916_E()) {
                return -1;
            }
            if (paramT1.func_190916_E() > paramT2.func_190916_E()) {
                return 1;
            }
            if (!paramT1.func_77942_o()) {
                return -1;
            }
            if (!paramT2.func_77942_o()) {
                return 1;
            }
            return paramT1.toString().compareTo(paramT2.toString());
        }
    }
}

