/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.client.shaders;

import com.xcompwiz.mystcraft.integration.lookingglass.DynamicLinkPanelRenderer;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.ARBShaderObjects;

public class ShaderUtils {
    public static int createShader(ResourceLocation resource, int shaderType) throws Exception {
        int shader = 0;
        try {
            shader = ARBShaderObjects.glCreateShaderObjectARB((int)shaderType);
            if (shader == 0) {
                return 0;
            }
            ARBShaderObjects.glShaderSourceARB((int)shader, (CharSequence)ShaderUtils.readFileAsString(resource));
            ARBShaderObjects.glCompileShaderARB((int)shader);
            if (ARBShaderObjects.glGetObjectParameteriARB((int)shader, (int)35713) == 0) {
                throw new RuntimeException("Error creating shader: " + ShaderUtils.getLogInfo(shader));
            }
            return shader;
        }
        catch (Exception exc) {
            ARBShaderObjects.glDeleteObjectARB((int)shader);
            throw exc;
        }
    }

    private static String getLogInfo(int obj) {
        return ARBShaderObjects.glGetInfoLogARB((int)obj, (int)ARBShaderObjects.glGetObjectParameteriARB((int)obj, (int)35716));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFileAsString(ResourceLocation r) throws Exception {
        StringBuilder source;
        block26: {
            source = new StringBuilder();
            InputStream in = Minecraft.func_71410_x().func_110442_L().func_110536_a(r).func_110527_b();
            Exception exception = null;
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                Exception innerExc = null;
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        source.append(line).append('\n');
                    }
                }
                catch (Exception exc) {
                    exception = exc;
                }
                finally {
                    try {
                        reader.close();
                    }
                    catch (Exception exc) {
                        innerExc = exc;
                    }
                }
                if (innerExc != null) {
                    throw innerExc;
                }
            }
            catch (Exception exc) {
                exception = exc;
                return exception;
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception exc) {
                    if (exception == null) {
                        exception = exc;
                    }
                    exc.printStackTrace();
                }
                if (exception == null) break block26;
                throw exception;
            }
        }
        return source.toString();
    }

    public static void registerShaders() {
        if (OpenGlHelper.field_148824_g) {
            ResourceLocation linkingpanel = new ResourceLocation("mystcraft", "shaders/linkingpanel.frag");
            ResourceLocation vlinkingpanel = new ResourceLocation("mystcraft", "shaders/linkingpanel.vert");
            try {
                DynamicLinkPanelRenderer.vertexARB = ShaderUtils.createShader(vlinkingpanel, 35633);
                DynamicLinkPanelRenderer.fragmentARB = ShaderUtils.createShader(linkingpanel, 35632);
            }
            catch (Exception exception) {
                // empty catch block
            }
            DynamicLinkPanelRenderer.shaderARB = ARBShaderObjects.glCreateProgramObjectARB();
            if (DynamicLinkPanelRenderer.shaderARB == 0 || DynamicLinkPanelRenderer.fragmentARB == 0) {
                return;
            }
            ARBShaderObjects.glAttachObjectARB((int)DynamicLinkPanelRenderer.shaderARB, (int)DynamicLinkPanelRenderer.vertexARB);
            ARBShaderObjects.glAttachObjectARB((int)DynamicLinkPanelRenderer.shaderARB, (int)DynamicLinkPanelRenderer.fragmentARB);
            ARBShaderObjects.glLinkProgramARB((int)DynamicLinkPanelRenderer.shaderARB);
            if (ARBShaderObjects.glGetObjectParameteriARB((int)DynamicLinkPanelRenderer.shaderARB, (int)35714) == 0) {
                return;
            }
            ARBShaderObjects.glValidateProgramARB((int)DynamicLinkPanelRenderer.shaderARB);
            if (ARBShaderObjects.glGetObjectParameteriARB((int)DynamicLinkPanelRenderer.shaderARB, (int)35714) == 0) {
                return;
            }
            DynamicLinkPanelRenderer.textureLoc = ARBShaderObjects.glGetUniformLocationARB((int)DynamicLinkPanelRenderer.shaderARB, (CharSequence)"u_texture");
            DynamicLinkPanelRenderer.damageLoc = ARBShaderObjects.glGetUniformLocationARB((int)DynamicLinkPanelRenderer.shaderARB, (CharSequence)"damage");
            DynamicLinkPanelRenderer.resLoc = ARBShaderObjects.glGetUniformLocationARB((int)DynamicLinkPanelRenderer.shaderARB, (CharSequence)"iResolution");
            DynamicLinkPanelRenderer.timeLoc = ARBShaderObjects.glGetUniformLocationARB((int)DynamicLinkPanelRenderer.shaderARB, (CharSequence)"iGlobalTime");
            DynamicLinkPanelRenderer.waveScaleLoc = ARBShaderObjects.glGetUniformLocationARB((int)DynamicLinkPanelRenderer.shaderARB, (CharSequence)"dWave");
            DynamicLinkPanelRenderer.colorScaleLoc = ARBShaderObjects.glGetUniformLocationARB((int)DynamicLinkPanelRenderer.shaderARB, (CharSequence)"dColor");
            DynamicLinkPanelRenderer.linkColorLoc = ARBShaderObjects.glGetUniformLocationARB((int)DynamicLinkPanelRenderer.shaderARB, (CharSequence)"linkColor");
        }
    }
}

