/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.client.gui.element;

import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import com.xcompwiz.mystcraft.client.gui.GuiUtils;
import com.xcompwiz.mystcraft.client.gui.element.GuiElement;
import com.xcompwiz.mystcraft.item.ItemPage;
import com.xcompwiz.mystcraft.page.Page;
import com.xcompwiz.mystcraft.symbol.SymbolManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class GuiElementPage
extends GuiElement {
    private IGuiPageProvider provider;
    private List<String> hovertext = new ArrayList<String>();
    private float xSizePage;
    private float ySizePage;

    public GuiElementPage(IGuiPageProvider provider, int guiLeft, int guiTop, float xSize, float ySize) {
        super(guiLeft, guiTop, (int)xSize, (int)ySize);
        this.provider = provider;
        this.xSizePage = xSize;
        this.ySizePage = ySize;
    }

    @Override
    public boolean isVisible() {
        ItemStack target = this.provider.getPageItemStack(this);
        return super.isVisible() && !target.func_190926_b() && target.func_77973_b() instanceof ItemPage;
    }

    @Override
    protected boolean _onMouseDown(int mouseX, int mouseY, int button) {
        if (this.contains(mouseX, mouseY)) {
            this.provider.interact(this);
            return true;
        }
        return false;
    }

    @Override
    public void _renderBackground(float f, int mouseX, int mouseY) {
        IAgeSymbol symbol2;
        int guiLeft = this.getLeft();
        int guiTop = this.getTop();
        this.hovertext.clear();
        ItemStack target = this.provider.getPageItemStack(this);
        ResourceLocation symbolRes = Page.getSymbol(target);
        GuiUtils.drawPage(this.mc.field_71446_o, this.getZLevel(), target, this.xSizePage, this.ySizePage, guiLeft, guiTop);
        if (GuiUtils.contains(mouseX, mouseY, guiLeft, guiTop, this.xSize, this.ySize) && symbolRes != null && (symbol2 = SymbolManager.getAgeSymbol(symbolRes)) != null) {
            this.hovertext.add(symbol2.getLocalizedName());
            GuiUtils.onItemTooltip(target, null, this.mc.field_71439_g, this.hovertext, ITooltipFlag.TooltipFlags.NORMAL);
        }
    }

    @Override
    public List<String> _getTooltipInfo() {
        if (!this.hovertext.isEmpty()) {
            return this.hovertext;
        }
        return super._getTooltipInfo();
    }

    public static interface IGuiPageProvider {
        @Nonnull
        public ItemStack getPageItemStack(GuiElementPage var1);

        public void interact(GuiElementPage var1);
    }
}

