/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.lib.reference;

import com.google.common.collect.Iterables;
import java.util.HashMap;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModAPIManager;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.VersionParser;

public class Mods {
    public static final String AsieLib = "asielib";
    public static final String AsieLib_NAME = "AsieLib";
    public static final String AE2 = "appliedenergistics2";
    public static final String IC2 = "IC2";
    public static final String IC2Classic = "IC2-Classic";
    public static final String Mekanism = "Mekanism";
    public static final String ProjectRed = "ProjRed|Core";
    public static final String RedLogic = "RedLogic";
    public static final String RedstoneFlux = "redstoneflux";
    private static HashMap<String, ArtifactVersion> modVersionList;
    private static boolean checkedEnergyMods;
    private static boolean hasEnergyMod;
    private static boolean checkedBundledMods;
    private static boolean hasBundledMod;

    public static boolean isLoaded(String name) {
        return Loader.isModLoaded((String)name);
    }

    public static ArtifactVersion getVersion(String name) {
        if (modVersionList == null) {
            modVersionList = new HashMap();
            for (ModContainer api : Iterables.concat((Iterable)Loader.instance().getActiveModList(), (Iterable)ModAPIManager.INSTANCE.getAPIList())) {
                modVersionList.put(api.getModId(), api.getProcessedVersion());
            }
        }
        if (modVersionList.containsKey(name)) {
            return modVersionList.get(name);
        }
        throw new IllegalArgumentException("Mod/API '" + name + "' does not exist!");
    }

    public static boolean hasVersion(String name, String version) {
        if (Mods.isLoaded(name) || API.hasAPI(name)) {
            ArtifactVersion v1 = VersionParser.parseVersionReference((String)(name + "@" + version));
            ArtifactVersion v2 = Mods.getVersion(name);
            return v1.containsVersion(v2);
        }
        return false;
    }

    public static boolean hasEnergyMod() {
        if (!checkedEnergyMods) {
            hasEnergyMod = API.hasAPI(RedstoneFlux) || Mods.isLoaded(IC2) || Mods.isLoaded(IC2Classic);
            checkedEnergyMods = true;
        }
        return hasEnergyMod;
    }

    public static boolean hasBundledRedstoneMod() {
        if (!checkedBundledMods) {
            hasBundledMod = API.hasAPI("CharsetAPI|Wires");
            checkedBundledMods = true;
        }
        return hasBundledMod;
    }

    static {
        checkedEnergyMods = false;
        hasEnergyMod = false;
        checkedBundledMods = false;
        hasBundledMod = false;
    }

    public static class API {
        public static final String BuildCraftTools = "BuildCraftAPI|tools";
        public static final String CharsetWires = "CharsetAPI|Wires";
        public static final String CoFHBlocks = "CoFHAPI|block";
        public static final String CoFHItems = "CoFHAPI|item";
        public static final String CoFHTileEntities = "CoFHAPI|tileentity";
        public static final String EiraIRC = "EiraIRC|API";
        public static final String EnderIOTools = "enderioapi|tools";
        public static final String OpenComputersInternal = "opencomputersapi|internal";

        public static boolean hasAPI(String name) {
            return ModAPIManager.INSTANCE.hasAPI(name);
        }
    }
}

