/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.lib.reference;

import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import pl.asie.lib.util.internal.IColorable;

public class Capabilities {
    public static final Capabilities INSTANCE = new Capabilities();
    @CapabilityInject(value=IColorable.class)
    public static Capability<IColorable> COLORABLE_CAPABILITY;
    private static final ResourceLocation COLORABLE_KEY;

    public void init() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        CapabilityManager.INSTANCE.register(IColorable.class, (Capability.IStorage)new ColorableStorage(), DefaultColorable.class);
    }

    @SubscribeEvent
    public void onAttachCapabilities(AttachCapabilitiesEvent<TileEntity> e) {
        final TileEntity tile = (TileEntity)e.getObject();
        if (tile instanceof IColorable) {
            e.addCapability(COLORABLE_KEY, new ICapabilityProvider(){

                public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
                    return capability == COLORABLE_CAPABILITY;
                }

                @Nullable
                public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
                    return (T)(this.hasCapability(capability, facing) ? COLORABLE_CAPABILITY.cast((Object)((IColorable)tile)) : null);
                }
            });
        }
    }

    private Capabilities() {
    }

    static {
        COLORABLE_KEY = new ResourceLocation("computronics:colorable");
    }

    private static class DefaultColorable
    implements IColorable {
        private int color = 0;

        private DefaultColorable() {
        }

        @Override
        public boolean canBeColored() {
            return false;
        }

        @Override
        public int getColor() {
            return this.color;
        }

        @Override
        public int getDefaultColor() {
            return 0;
        }

        @Override
        public void setColor(int color) {
            this.color = color;
        }
    }

    private static class ColorableStorage
    implements Capability.IStorage<IColorable> {
        private ColorableStorage() {
        }

        public NBTBase writeNBT(Capability<IColorable> capability, IColorable instance, EnumFacing side) {
            return new NBTTagInt(instance.getColor());
        }

        public void readNBT(Capability<IColorable> capability, IColorable instance, EnumFacing side, NBTBase nbt) {
            if (nbt instanceof NBTTagInt) {
                instance.setColor(((NBTTagInt)nbt).func_150287_d());
            }
        }
    }
}

