/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.lib.audio;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL10;
import pl.asie.lib.AsieLibMod;
import pl.asie.lib.audio.DFPWM;

public class StreamingAudioPlayer
extends DFPWM {
    private final Set<SourceEntry> sources = new HashSet<SourceEntry>();
    private final ArrayList<IntBuffer> buffersPlayed = new ArrayList();
    private final int BUFFER_PACKETS;
    private final int AUDIO_FORMAT;
    private IntBuffer currentBuffer;
    private int sampleRate = 48000;
    private float volume = 1.0f;
    private float distance = 24.0f;

    public StreamingAudioPlayer(boolean sixteenBit, boolean stereo, int bufferPackets) {
        this.BUFFER_PACKETS = bufferPackets;
        this.AUDIO_FORMAT = sixteenBit ? (stereo ? 4355 : 4353) : (stereo ? 4354 : 4352);
        this.reset();
    }

    public void setHearing(float dist, float vol) {
        this.distance = dist;
        this.volume = vol;
    }

    public void setSampleRate(int rate) {
        this.sampleRate = rate;
    }

    public void reset() {
        this.buffersPlayed.clear();
        this.stop();
    }

    public void updatePosition(String id, float x, float y, float z) {
        for (SourceEntry source : this.sources) {
            if (id == null || !id.equals(source.id)) continue;
            AL10.alSource3f((int)source.src.get(0), (int)4100, (float)x, (float)y, (float)z);
            return;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private double getDistance(double x, double y, double z) {
        Vec3d pos = Minecraft.func_71410_x().field_71439_g.func_174791_d();
        return pos.func_72438_d(new Vec3d(x, y, z));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(byte[] data) {
        if (this.currentBuffer == null) {
            this.currentBuffer = BufferUtils.createIntBuffer((int)1);
        } else {
            for (SourceEntry source : this.sources) {
                int processed = AL10.alGetSourcei((int)source.src.get(0), (int)4118);
                if (processed <= 0) continue;
                AL10.alSourceUnqueueBuffers((int)source.src.get(0), (IntBuffer)this.currentBuffer);
            }
        }
        AL10.alGenBuffers((IntBuffer)this.currentBuffer);
        AL10.alBufferData((int)this.currentBuffer.get(0), (int)this.AUDIO_FORMAT, (ByteBuffer)((ByteBuffer)BufferUtils.createByteBuffer((int)data.length).put(data).flip()), (int)this.sampleRate);
        ArrayList<IntBuffer> arrayList = this.buffersPlayed;
        synchronized (arrayList) {
            this.buffersPlayed.add(this.currentBuffer);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void play(String id, float x, float y, float z) {
        this.play(id, x, y, z, 0.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void play(String id, float x, float y, float z, float rolloff) {
        FloatBuffer sourcePos = (FloatBuffer)BufferUtils.createFloatBuffer((int)3).put(new float[]{x, y, z}).rewind();
        FloatBuffer sourceVel = (FloatBuffer)BufferUtils.createFloatBuffer((int)3).put(new float[]{0.0f, 0.0f, 0.0f}).rewind();
        SourceEntry source = null;
        for (SourceEntry entry : this.sources) {
            if (!id.equals(entry.id)) continue;
            source = entry;
        }
        if (source == null) {
            source = new SourceEntry(id);
            this.sources.add(source);
        }
        float playerDistance = (float)this.getDistance(x, y, z);
        float distanceUsed = this.distance * (0.2f + this.volume * 0.8f);
        float distanceReal = rolloff <= 0.0f ? 1.0f - playerDistance / distanceUsed : (playerDistance / distanceUsed >= 1.0f ? 0.0f : 1.0f);
        float gain = distanceReal * this.volume * Minecraft.func_71410_x().field_71474_y.func_186711_a(SoundCategory.RECORDS);
        if (gain < 0.0f) {
            gain = 0.0f;
        } else if (gain > 1.0f) {
            gain = 1.0f;
        }
        AL10.alSourcei((int)source.src.get(0), (int)4103, (int)0);
        AL10.alSourcef((int)source.src.get(0), (int)4099, (float)1.0f);
        AL10.alSourcef((int)source.src.get(0), (int)4106, (float)gain);
        AL10.alSource((int)source.src.get(0), (int)4100, (FloatBuffer)sourcePos);
        AL10.alSource((int)source.src.get(0), (int)4102, (FloatBuffer)sourceVel);
        AL10.alSourcef((int)source.src.get(0), (int)4129, (float)(6.0f / distanceUsed));
        AL10.alSourceQueueBuffers((int)source.src.get(0), (IntBuffer)this.currentBuffer);
        int state = AL10.alGetSourcei((int)source.src.get(0), (int)4112);
        if (source.receivedPackets > this.BUFFER_PACKETS && state != 4114) {
            AL10.alSourcePlay((int)source.src.get(0));
        } else if (source.receivedPackets <= this.BUFFER_PACKETS) {
            AL10.alSourcePause((int)source.src.get(0));
        }
        ++source.receivedPackets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        int sourceCount = this.sources.size();
        for (SourceEntry source : this.sources) {
            AL10.alSourceStop((int)source.src.get(0));
            AL10.alDeleteSources((int)source.src.get(0));
        }
        this.sources.clear();
        int bufferCount = 0;
        if (this.buffersPlayed != null) {
            ArrayList<IntBuffer> arrayList = this.buffersPlayed;
            synchronized (arrayList) {
                if (this.currentBuffer != null) {
                    this.buffersPlayed.add(this.currentBuffer);
                }
                for (IntBuffer b : this.buffersPlayed) {
                    b.rewind();
                    for (int i = 0; i < b.limit(); ++i) {
                        int buffer = b.get(i);
                        if (!AL10.alIsBuffer((int)buffer)) continue;
                        AL10.alDeleteBuffers((int)buffer);
                        ++bufferCount;
                    }
                }
                this.buffersPlayed.clear();
            }
        }
        AsieLibMod.log.debug("Cleaned " + bufferCount + " buffers and " + sourceCount + " sources.");
    }

    public class SourceEntry {
        public final String id;
        public final IntBuffer src;
        public int receivedPackets;

        public SourceEntry(String id) {
            this.id = id;
            this.src = BufferUtils.createIntBuffer((int)1);
            AL10.alGenSources((IntBuffer)this.src);
        }
    }
}

