/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.util;

import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import pl.asie.computronics.reference.Config;

public class Camera {
    private World world;
    private float xDirection;
    private float yDirection;
    private float zDirection;
    private double oxPos;
    private double oyPos;
    private double ozPos;
    private double xPos;
    private double yPos;
    private double zPos;
    private Object hit;

    public boolean ray(World worldObj, int xCoord, int yCoord, int zCoord, EnumFacing dir, float x, float y) {
        return this.ray(worldObj, (double)xCoord + 0.5, (double)yCoord + 0.5, (double)zCoord + 0.5, dir, x, y, true);
    }

    public boolean ray(World worldObj, double xCoord, double yCoord, double zCoord, EnumFacing dir, float x, float y, boolean doBlockOffset) {
        this.hit = null;
        if (x < -1.0f || x > 1.0f || y < -1.0f || y > 1.0f) {
            return false;
        }
        this.xDirection = 0.0f;
        this.yDirection = y;
        this.zDirection = 0.0f;
        double oxOffset = 0.0;
        double oyOffset = 0.0;
        double ozOffset = 0.0;
        switch (dir) {
            case EAST: {
                this.xDirection = 1.0f;
                this.zDirection = -x;
                if (!doBlockOffset) break;
                xCoord += 0.6;
                oxOffset = -0.1;
                break;
            }
            case NORTH: {
                this.zDirection = -1.0f;
                this.xDirection = x;
                if (!doBlockOffset) break;
                zCoord -= 0.6;
                ozOffset = 0.1;
                break;
            }
            case SOUTH: {
                this.zDirection = 1.0f;
                this.xDirection = -x;
                if (!doBlockOffset) break;
                zCoord += 0.6;
                ozOffset = -0.1;
                break;
            }
            case WEST: {
                this.xDirection = -1.0f;
                this.zDirection = x;
                if (!doBlockOffset) break;
                xCoord -= 0.6;
                oxOffset = 0.1;
                break;
            }
            case DOWN: {
                this.yDirection = -1.0f;
                this.xDirection = x;
                this.zDirection = y;
                if (!doBlockOffset) break;
                yCoord -= 0.6;
                oyOffset = 0.1;
                break;
            }
            case UP: {
                this.yDirection = 1.0f;
                this.xDirection = x;
                this.zDirection = y;
                if (!doBlockOffset) break;
                yCoord += 0.6;
                oyOffset = -0.1;
                break;
            }
            default: {
                return false;
            }
        }
        this.world = worldObj;
        this.xPos = xCoord;
        this.yPos = yCoord;
        this.zPos = zCoord;
        this.oxPos = this.xPos;
        this.oyPos = this.yPos;
        this.ozPos = this.zPos;
        BlockPos pos = new BlockPos((int)Math.floor(this.xPos), (int)Math.floor(this.yPos), (int)Math.floor(this.zPos));
        if (!this.world.func_175623_d(pos)) {
            this.hit = this.world.func_180495_p(pos).func_177230_c();
            return true;
        }
        Vec3d origin = new Vec3d(this.xPos, this.yPos, this.zPos);
        float steps = Config.CAMERA_DISTANCE;
        Vec3d target = new Vec3d(this.xPos + (double)(this.xDirection * steps), this.yPos + (double)(this.yDirection * steps), this.zPos + (double)(this.zDirection * steps));
        RayTraceResult mop = this.world.func_72933_a(origin, target);
        if (mop != null) {
            this.xPos = mop.field_72307_f.field_72450_a;
            this.yPos = mop.field_72307_f.field_72448_b;
            this.zPos = mop.field_72307_f.field_72449_c;
            this.oxPos += oxOffset;
            this.oyPos += oyOffset;
            this.ozPos += ozOffset;
            switch (mop.field_72313_a) {
                case ENTITY: {
                    this.hit = mop.field_72308_g;
                    break;
                }
                case BLOCK: {
                    this.hit = this.world.func_180495_p(mop.func_178782_a());
                    break;
                }
            }
        }
        return true;
    }

    public double getDistance() {
        if (this.hit == null) {
            return -1.0;
        }
        double x = this.xPos - this.oxPos;
        double y = this.yPos - this.oyPos;
        double z = this.zPos - this.ozPos;
        return Math.sqrt(x * x + y * y + z * z);
    }
}

