/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.oc.driver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nullable;
import li.cil.oc.api.Network;
import li.cil.oc.api.internal.Rotatable;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.EnvironmentHost;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.Optional;
import pl.asie.charset.api.audio.IAudioSource;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.api.audio.AudioPacket;
import pl.asie.computronics.api.audio.AudioPacketDFPWM;
import pl.asie.computronics.api.audio.IAudioReceiver;
import pl.asie.computronics.audio.AudioUtils;
import pl.asie.computronics.audio.tts.TextToSpeech;
import pl.asie.computronics.integration.charset.audio.IntegrationCharsetAudio;
import pl.asie.computronics.oc.driver.ManagedEnvironmentWithComponentConnector;
import pl.asie.computronics.reference.Capabilities;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.reference.Mods;
import pl.asie.computronics.util.ColorUtils;
import pl.asie.computronics.util.OCUtils;
import pl.asie.lib.util.internal.IColorable;

public class RobotUpgradeSpeech
extends ManagedEnvironmentWithComponentConnector
implements pl.asie.computronics.api.audio.IAudioSource,
ICapabilityProvider,
TextToSpeech.ICanSpeak {
    protected final EnvironmentHost host;
    private final IAudioReceiver internalSpeaker = new IAudioReceiver(){

        @Override
        public boolean connectsAudio(EnumFacing side) {
            return true;
        }

        @Override
        public World getSoundWorld() {
            return RobotUpgradeSpeech.this.host.world();
        }

        @Override
        public Vec3d getSoundPos() {
            return RobotUpgradeSpeech.this.getPos();
        }

        @Override
        public int getSoundDistance() {
            return Config.TAPEDRIVE_DISTANCE;
        }

        @Override
        public void receivePacket(AudioPacket packet, @Nullable EnumFacing direction) {
            packet.addReceiver(this);
        }

        @Override
        public String getID() {
            return RobotUpgradeSpeech.this.host instanceof TileEntity ? AudioUtils.positionId(RobotUpgradeSpeech.this.host.xPosition(), RobotUpgradeSpeech.this.host.yPosition(), RobotUpgradeSpeech.this.host.zPosition()) : "";
        }
    };
    protected boolean isValid = false;
    private long lastCodecTime;
    private int codecId = -1;
    protected int packetSize = 1500;
    protected int soundVolume = 127;
    private boolean locked = false;
    private ByteArrayInputStream storage;
    private Object charsetAudioSource;

    public RobotUpgradeSpeech(EnvironmentHost host) {
        this.host = host;
        this.setNode(Network.newNode((Environment)this, (Visibility)Visibility.Neighbors).withComponent("speech").withConnector().create());
    }

    protected Vec3d getPos() {
        return new Vec3d(this.host.xPosition(), this.host.yPosition(), this.host.zPosition());
    }

    public boolean canUpdate() {
        return true;
    }

    public void update() {
        super.update();
        AudioPacket pkt = null;
        long time = System.nanoTime();
        if (time - 250000000L > this.lastCodecTime) {
            this.lastCodecTime += 250000000L;
            pkt = this.createMusicPacket(this);
        }
        int receivers = 0;
        boolean sent = false;
        if (pkt != null) {
            if (this.host instanceof TileEntity && Mods.API.hasAPI("CharsetAPI|Audio")) {
                int oldReceivers = receivers;
                if ((receivers += IntegrationCharsetAudio.send((IBlockAccess)this.host.world(), ((TileEntity)this.host).func_174877_v(), pkt, 1.0f, true)) > oldReceivers) {
                    sent = true;
                }
            }
            if (!sent) {
                if (this.host instanceof TileEntity) {
                    for (EnumFacing dir : EnumFacing.field_82609_l) {
                        TileEntity tile = this.host.world().func_175625_s(((TileEntity)this.host).func_174877_v().func_177972_a(dir));
                        if (tile == null || !tile.hasCapability(Capabilities.AUDIO_RECEIVER_CAPABILITY, dir.func_176734_d())) continue;
                        IColorable hostCol = ColorUtils.getColorable((ICapabilityProvider)((TileEntity)this.host), dir);
                        IColorable targetCol = ColorUtils.getColorable((ICapabilityProvider)tile, dir.func_176734_d());
                        if (hostCol != null && targetCol != null && hostCol.canBeColored() && targetCol.canBeColored() && !ColorUtils.isSameOrDefault(hostCol, targetCol)) continue;
                        ((IAudioReceiver)tile.getCapability(Capabilities.AUDIO_RECEIVER_CAPABILITY, dir.func_176734_d())).receivePacket(pkt, dir.func_176734_d());
                        ++receivers;
                    }
                }
                if (receivers == 0) {
                    this.internalSpeaker.receivePacket(pkt, null);
                }
                pkt.sendPacket();
            }
        }
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    public void onConnect(Node node) {
        super.onConnect(node);
        if (node == this.node()) {
            this.isValid = true;
        }
    }

    public void onDisconnect(Node node) {
        super.onDisconnect(node);
        if (node == this.node()) {
            this.isValid = false;
            this.stopTalking();
        }
    }

    public void onMessage(Message message) {
        super.onMessage(message);
        if ((message.name().equals("computer.stopped") || message.name().equals("computer.started")) && this.node().isNeighborOf(message.source())) {
            if (this.locked || this.storage != null) {
                this.stopTalking();
            }
            this.isValid = message.name().equals("computer.started");
        }
    }

    @Override
    public void startTalking(byte[] data) {
        if (this.host.world().field_72995_K) {
            return;
        }
        this.storage = new ByteArrayInputStream(data);
        this.codecId = Computronics.instance.audio.newPlayer();
        Computronics.instance.audio.getPlayer(this.codecId);
        this.lastCodecTime = System.nanoTime();
    }

    private void stopTalking() {
        if (this.host.world() != null && this.host.world().field_72995_K) {
            return;
        }
        AudioUtils.removePlayer(Computronics.instance.managerId, this.codecId);
        this.locked = false;
        this.storage = null;
    }

    private Object[] sendNewText(String text) throws IOException {
        if (Computronics.tts == null) {
            return new Object[]{false, "text-to-speech system not available"};
        }
        this.locked = true;
        Computronics.tts.say(this, text);
        return new Object[]{true};
    }

    @Nullable
    private AudioPacket createMusicPacket(pl.asie.computronics.api.audio.IAudioSource source) {
        if (this.storage == null) {
            return null;
        }
        byte[] pktData = new byte[this.packetSize];
        int amount = this.storage.read(pktData, 0, pktData.length);
        if (amount > 0) {
            return new AudioPacketDFPWM(source, (byte)this.soundVolume, this.packetSize * 8 * 4, amount == this.packetSize ? pktData : Arrays.copyOf(pktData, amount));
        }
        this.stopTalking();
        return null;
    }

    public void load(NBTTagCompound tag) {
        super.load(tag);
        if (this.soundVolume != 127) {
            tag.func_74774_a("vo", (byte)this.soundVolume);
        }
    }

    public void save(NBTTagCompound tag) {
        super.save(tag);
        this.soundVolume = tag.func_74764_b("vo") ? (int)tag.func_74771_c("vo") : 127;
    }

    public void setVolume(float volume) {
        if (volume < 0.0f) {
            volume = 0.0f;
        }
        if (volume > 1.0f) {
            volume = 1.0f;
        }
        this.soundVolume = (int)Math.floor(volume * 127.0f);
    }

    @Callback(doc="function(text:string):boolean; Say the specified message. Returns true on success, false and an error message otherwise.")
    @Optional.Method(modid="opencomputers")
    public Object[] say(Context context, Arguments args) {
        if (this.locked || this.storage != null) {
            return new Object[]{false, "already processing"};
        }
        String text = args.checkString(0);
        if (text.length() > Config.TTS_MAX_LENGTH) {
            return new Object[]{false, "text too long"};
        }
        try {
            return this.sendNewText(text);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("could not send string");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Callback(doc="function():boolean; Stops the currently spoken phrase. Returns true on success, false and an error message otherwise.")
    @Optional.Method(modid="opencomputers")
    public Object[] stop(Context context, Arguments args) {
        if (this.locked || this.storage != null) {
            this.stopTalking();
            return new Object[]{true};
        }
        return new Object[]{false, "not talking"};
    }

    @Callback(doc="function():boolean; Returns true if the device is currently processing text.", direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] isProcessing(Context context, Arguments args) {
        return new Object[]{this.locked || this.storage != null};
    }

    @Callback(doc="function(speed:number); Sets the volume of the speech box. Needs to be beween 0 and 1")
    @Optional.Method(modid="opencomputers")
    public Object[] setVolume(Context context, Arguments args) {
        this.setVolume((float)args.checkDouble(0));
        return new Object[0];
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        EnumFacing enumFacing = facing = this.host instanceof Rotatable ? ((Rotatable)this.host).toGlobal(facing) : facing;
        if (Mods.API.hasAPI("CharsetAPI|Audio") && capability == IntegrationCharsetAudio.SOURCE_CAPABILITY && facing != null && this.connectsAudio(facing)) {
            return true;
        }
        return capability == Capabilities.AUDIO_SOURCE_CAPABILITY && facing != null && this.connectsAudio(facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        EnumFacing enumFacing = facing = this.host instanceof Rotatable ? ((Rotatable)this.host).toGlobal(facing) : facing;
        if (Mods.API.hasAPI("CharsetAPI|Audio") && capability == IntegrationCharsetAudio.SOURCE_CAPABILITY && facing != null && this.connectsAudio(facing)) {
            if (this.charsetAudioSource == null) {
                this.charsetAudioSource = new IAudioSource(){};
            }
            return (T)IntegrationCharsetAudio.SOURCE_CAPABILITY.cast((Object)((IAudioSource)this.charsetAudioSource));
        }
        if (capability == Capabilities.AUDIO_SOURCE_CAPABILITY && facing != null && this.connectsAudio(facing)) {
            return (T)Capabilities.AUDIO_SOURCE_CAPABILITY.cast((Object)this);
        }
        return null;
    }

    @Override
    public boolean connectsAudio(EnumFacing side) {
        if (this.host instanceof TileEntity) {
            IColorable hostCol = ColorUtils.getColorable((ICapabilityProvider)((TileEntity)this.host), side);
            IColorable targetCol = ColorUtils.getColorable((ICapabilityProvider)this.host.world().func_175625_s(((TileEntity)this.host).func_174877_v().func_177972_a(side)), side.func_176734_d());
            if (hostCol != null && targetCol != null && hostCol.canBeColored() && targetCol.canBeColored()) {
                return ColorUtils.isSameOrDefault(hostCol, targetCol);
            }
        }
        return true;
    }

    @Override
    public int getSourceId() {
        return this.codecId;
    }

    @Override
    @Optional.Method(modid="opencomputers")
    protected OCUtils.Device deviceInfo() {
        return new OCUtils.Device("multimedia", "Text-To-Speech Interface", "DFKI GmbH", "Mary", new String[0]);
    }
}

