/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.oc;

import java.util.Locale;
import li.cil.oc.api.event.RobotAnalyzeEvent;
import li.cil.oc.api.event.RobotRenderEvent;
import li.cil.oc.api.internal.Agent;
import li.cil.oc.api.internal.Robot;
import li.cil.oc.api.network.Node;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.computronics.item.ItemOpenComputers;
import pl.asie.computronics.oc.driver.RobotUpgradeColorful;

public class ColorfulUpgradeHandler {
    @SubscribeEvent
    @Optional.Method(modid="opencomputers")
    public void onRobotAnalyze(RobotAnalyzeEvent e) {
        int color = this.getColor(e.agent);
        if (color < 0) {
            return;
        }
        e.player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.computronics.colorful_upgrade.color", new Object[]{"0x" + String.format("%06x", color).toUpperCase(Locale.ENGLISH)}), false);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOW)
    @Optional.Method(modid="opencomputers")
    public void onRobotRender(RobotRenderEvent e) {
        int color = -1;
        if (e.agent instanceof Robot) {
            Robot robot = (Robot)e.agent;
            for (int i = 0; i < robot.func_70302_i_(); ++i) {
                int newcol;
                NBTTagCompound tag;
                ItemStack stack = robot.func_70301_a(i);
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemOpenComputers) || stack.func_77952_i() != 7 || !(tag = ((ItemOpenComputers)stack.func_77973_b()).dataTag(stack)).func_74764_b("computronics:color") || (newcol = tag.func_74762_e("computronics:color")) <= color) continue;
                color = newcol;
            }
        }
        if (color < 0) {
            return;
        }
        GlStateManager.func_179124_c((float)((float)((color &= 0xFFFFFF) >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f));
    }

    @Optional.Method(modid="opencomputers")
    private int getColor(Agent agent) {
        try {
            for (Node node : agent.machine().node().reachableNodes()) {
                if (node == null || !(node.host() instanceof RobotUpgradeColorful)) continue;
                return ((RobotUpgradeColorful)node.host()).getColor();
            }
        }
        catch (NullPointerException e) {
            return -1;
        }
        return -1;
    }
}

