/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.railcraft.tile;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Locale;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import mods.railcraft.api.signals.IControllerTile;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.api.signals.SignalController;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.RailcraftInputStream;
import mods.railcraft.common.util.network.RailcraftOutputStream;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import pl.asie.computronics.integration.railcraft.SignalTypes;
import pl.asie.computronics.integration.railcraft.signalling.MassiveSignalController;
import pl.asie.computronics.integration.railcraft.tile.TileDigitalBoxBase;
import pl.asie.computronics.util.OCUtils;
import pl.asie.computronics.util.TableUtils;

@Optional.InterfaceList(value={@Optional.Interface(iface="mods.railcraft.api.signals.IControllerTile", modid="railcraft")})
public class TileDigitalControllerBox
extends TileDigitalBoxBase
implements IControllerTile {
    private boolean prevBlinkState;
    private final MassiveSignalController controller = new MassiveSignalController(this.func_70005_c_(), (TileEntity)this);
    private static LinkedHashMap<Object, Object> aspectMap;

    public TileDigitalControllerBox() {
        super("digital_controller_box");
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (Game.isClient((World)this.field_145850_b)) {
            this.controller.tickClient();
            if (this.controller.getVisualAspect().isBlinkAspect() && this.prevBlinkState != SignalAspect.isBlinkOn()) {
                this.prevBlinkState = SignalAspect.isBlinkOn();
                this.markBlockForUpdate();
            }
        } else {
            this.controller.tickServer();
            SignalAspect prevAspect = this.controller.getVisualAspect();
            if (this.controller.isBeingPaired()) {
                this.controller.setVisualAspect(SignalAspect.BLINK_YELLOW);
            } else if (this.controller.isPaired()) {
                this.controller.setVisualAspect(this.controller.getMostRestrictiveAspect());
            } else {
                this.controller.setVisualAspect(SignalAspect.BLINK_RED);
            }
            if (prevAspect != this.controller.getVisualAspect()) {
                this.sendUpdateToClient();
            }
        }
    }

    public SignalController getController() {
        return this.controller;
    }

    public boolean isConnected(EnumFacing side) {
        return false;
    }

    public SignalAspect getBoxSignalAspect(EnumFacing side) {
        return this.controller.getVisualAspect();
    }

    public IEnumMachine<?> getMachineType() {
        return SignalTypes.DigitalController;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        data = super.func_189515_b(data);
        this.controller.writeToNBT(data);
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.controller.readFromNBT(data);
    }

    public void writePacketData(RailcraftOutputStream data) throws IOException {
        super.writePacketData((DataOutputStream)data);
        this.controller.writePacketData((DataOutputStream)data);
    }

    public void readPacketData(RailcraftInputStream data) throws IOException {
        super.readPacketData((DataInputStream)data);
        this.controller.readPacketData((DataInputStream)data);
        this.markBlockForUpdate();
    }

    @Override
    @Optional.Method(modid="opencomputers")
    protected OCUtils.Device deviceInfo() {
        return new OCUtils.Device("communication", "Signal controller", "Railcraft, Inc.", "Digitized Signal Sender X3", new String[0]);
    }

    private Object[] setAspect(String name, int aspectIndex) {
        if (aspectIndex > 0 && aspectIndex < SignalAspect.VALUES.length) {
            SignalAspect aspect = SignalAspect.fromOrdinal((int)(aspectIndex - 1));
            boolean success = this.controller.setAspectFor(name, aspect);
            if (success) {
                return new Object[]{true};
            }
            return new Object[]{false, "no valid signal found"};
        }
        throw new IllegalArgumentException("invalid aspect: " + aspectIndex);
    }

    private Object[] setEveryAspect(int aspectIndex) {
        if (aspectIndex > 0 && aspectIndex < SignalAspect.VALUES.length) {
            SignalAspect aspect = SignalAspect.fromOrdinal((int)(aspectIndex - 1));
            this.controller.setAspectForAll(aspect);
            return new Object[]{true};
        }
        throw new IllegalArgumentException("invalid aspect" + aspectIndex);
    }

    private Object[] removeSignal(String name) {
        Collection<BlockPos> coords = this.controller.getCoordsFor(name);
        if (!coords.isEmpty()) {
            for (BlockPos coord : coords) {
                this.controller.clearPairing(coord);
            }
            return new Object[]{true};
        }
        return new Object[]{false, "no valid signal found"};
    }

    private Object[] getSignalNames() {
        return new Object[]{TableUtils.convertSetToMap(this.controller.getSignalNames())};
    }

    private static Object[] aspects() {
        if (aspectMap == null) {
            LinkedHashMap<Object, Object> newMap = new LinkedHashMap<Object, Object>();
            for (int i = 0; i < SignalAspect.VALUES.length - 1; ++i) {
                SignalAspect aspect = SignalAspect.VALUES[i];
                String name = aspect.name().toLowerCase(Locale.ENGLISH);
                newMap.put(name, aspect.ordinal() + 1);
                newMap.put(aspect.ordinal() + 1, name);
            }
            aspectMap = newMap;
        }
        return new Object[]{aspectMap};
    }

    @Callback(doc="function(name:string, aspect:number):boolean; Tries to set the aspect for any paired signal with the specified name. Returns true on success.", direct=true, limit=32)
    @Optional.Method(modid="opencomputers")
    public Object[] setAspect(Context context, Arguments args) {
        return this.setAspect(args.checkString(0), args.checkInteger(1));
    }

    @Callback(doc="function(aspect:number):boolean; Sets the aspect for every paired signal to the specified value. Returns true on success.", direct=true, limit=32)
    @Optional.Method(modid="opencomputers")
    public Object[] setEveryAspect(Context context, Arguments args) {
        return this.setEveryAspect(args.checkInteger(0));
    }

    @Callback(doc="function(name:string):boolean; Tries to remove any pairing to a signal with the specified name. Returns true on success.", direct=true, limit=32)
    @Optional.Method(modid="opencomputers")
    public Object[] unpair(Context context, Arguments args) {
        return this.removeSignal(args.checkString(0));
    }

    @Callback(doc="function():table; Returns a list containing the name of every paired receiver.", direct=true, limit=32)
    @Optional.Method(modid="opencomputers")
    public Object[] getSignalNames(Context c, Arguments a) {
        return this.getSignalNames();
    }

    @Callback(doc="This is a list of every available Signal Aspect in Railcraft", getter=true, direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] aspects(Context c, Arguments a) {
        return TileDigitalControllerBox.aspects();
    }

    @Optional.Method(modid="computercraft")
    public String[] getMethodNames() {
        return new String[]{"setAspect", "setEveryAspect", "unpair", "getSignalNames", "aspects"};
    }

    @Optional.Method(modid="computercraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        try {
            if (method < this.getMethodNames().length) {
                switch (method) {
                    case 0: {
                        if (arguments.length < 1 || !(arguments[0] instanceof String)) {
                            throw new LuaException("first argument needs to be a string");
                        }
                        if (arguments.length < 2 || !(arguments[1] instanceof Number)) {
                            throw new LuaException("second argument needs to be a number");
                        }
                        return this.setAspect((String)arguments[0], ((Number)arguments[1]).intValue());
                    }
                    case 1: {
                        if (arguments.length < 1 || !(arguments[0] instanceof Number)) {
                            throw new LuaException("first argument needs to be a number");
                        }
                        return this.setEveryAspect(((Number)arguments[1]).intValue());
                    }
                    case 2: {
                        if (arguments.length < 1 || !(arguments[0] instanceof String)) {
                            throw new LuaException("first argument needs to be a string");
                        }
                        return this.removeSignal((String)arguments[0]);
                    }
                    case 3: {
                        return this.getSignalNames();
                    }
                    case 4: {
                        return TileDigitalControllerBox.aspects();
                    }
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new LuaException(e.getMessage());
        }
    }
}

