/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.railcraft.tile;

import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;
import li.cil.oc.api.Network;
import li.cil.oc.api.driver.DeviceInfo;
import li.cil.oc.api.network.BlacklistedPeripheral;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.SidedEnvironment;
import li.cil.oc.api.network.Visibility;
import mods.railcraft.common.blocks.machine.wayobjects.boxes.TileBoxBase;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.computronics.api.multiperipheral.IMultiPeripheral;
import pl.asie.computronics.cc.ISidedPeripheral;
import pl.asie.computronics.reference.Mods;
import pl.asie.computronics.util.OCUtils;
import pl.asie.computronics.util.internal.IComputronicsPeripheral;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.Environment", modid="opencomputers"), @Optional.Interface(iface="li.cil.oc.api.network.SidedEnvironment", modid="opencomputers"), @Optional.Interface(iface="li.cil.oc.api.driver.DeviceInfo", modid="opencomputers"), @Optional.Interface(iface="li.cil.oc.api.network.BlacklistedPeripheral", modid="opencomputers"), @Optional.Interface(iface="pl.asie.computronics.api.multiperipheral.IMultiPeripheral", modid="computercraft")})
public abstract class TileDigitalBoxBase
extends TileBoxBase
implements Environment,
SidedEnvironment,
DeviceInfo,
IMultiPeripheral,
IComputronicsPeripheral,
ISidedPeripheral,
BlacklistedPeripheral,
ITickable {
    protected String peripheralName;
    protected Object node;
    protected CopyOnWriteArrayList<IComputerAccess> attachedComputersCC;
    protected boolean addedToNetwork = false;
    protected Map<String, String> deviceInfo;

    public TileDigitalBoxBase(String name) {
        this.peripheralName = name;
        if (Mods.isLoaded("opencomputers")) {
            this.initOC();
        }
    }

    public TileDigitalBoxBase(String name, double bufferSize) {
        this.peripheralName = name;
        if (Mods.isLoaded("opencomputers")) {
            this.initOC(bufferSize);
        }
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (!this.addedToNetwork && Mods.isLoaded("opencomputers")) {
            this.addedToNetwork = true;
            Network.joinOrCreateNetwork((TileEntity)this);
        }
    }

    public Block func_145838_q() {
        if (this.field_145854_h == null && this.field_145850_b != null) {
            this.field_145854_h = this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
        }
        return this.field_145854_h;
    }

    public boolean isSideSolid(EnumFacing side) {
        return side == EnumFacing.UP;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        data = super.func_189515_b(data);
        if (Mods.isLoaded("opencomputers")) {
            this.writeToNBT_OC(data);
        }
        return data;
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        if (Mods.isLoaded("opencomputers")) {
            this.readFromNBT_OC(data);
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (Mods.isLoaded("opencomputers")) {
            this.onChunkUnload_OC();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (Mods.isLoaded("opencomputers")) {
            this.invalidate_OC();
        }
    }

    @Optional.Method(modid="opencomputers")
    public boolean isPeripheralBlacklisted() {
        return true;
    }

    @Optional.Method(modid="opencomputers")
    public Node node() {
        return (Node)this.node;
    }

    @Optional.Method(modid="opencomputers")
    public void onConnect(Node node) {
    }

    @Optional.Method(modid="opencomputers")
    public void onDisconnect(Node node) {
    }

    @Optional.Method(modid="opencomputers")
    public void onMessage(Message message) {
    }

    @Optional.Method(modid="opencomputers")
    public Map<String, String> getDeviceInfo() {
        OCUtils.Device device;
        if (this.deviceInfo == null && (device = this.deviceInfo()) != null) {
            this.deviceInfo = device.deviceInfo();
            return this.deviceInfo;
        }
        return this.deviceInfo;
    }

    @Optional.Method(modid="opencomputers")
    protected abstract OCUtils.Device deviceInfo();

    @Nullable
    @Optional.Method(modid="opencomputers")
    public Node sidedNode(EnumFacing forgeDirection) {
        return forgeDirection == EnumFacing.DOWN || forgeDirection == EnumFacing.UP ? this.node() : null;
    }

    @Optional.Method(modid="opencomputers")
    @SideOnly(value=Side.CLIENT)
    public boolean canConnect(EnumFacing forgeDirection) {
        return forgeDirection == EnumFacing.DOWN || forgeDirection == EnumFacing.UP;
    }

    @Optional.Method(modid="computercraft")
    public String getType() {
        return this.peripheralName;
    }

    @Optional.Method(modid="opencomputers")
    private void initOC(double s) {
        this.node = Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(this.peripheralName, Visibility.Network).withConnector(s).create();
    }

    @Optional.Method(modid="opencomputers")
    private void initOC() {
        this.node = Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(this.peripheralName, Visibility.Network).create();
    }

    @Optional.Method(modid="opencomputers")
    public void readFromNBT_OC(NBTTagCompound nbt) {
        if (this.node() != null && this.node().host() == this) {
            this.node().load(nbt.func_74775_l("oc:node"));
        }
    }

    @Optional.Method(modid="opencomputers")
    public void writeToNBT_OC(NBTTagCompound nbt) {
        if (this.node() != null && this.node().host() == this) {
            NBTTagCompound nodeNbt = new NBTTagCompound();
            this.node().save(nodeNbt);
            nbt.func_74782_a("oc:node", (NBTBase)nodeNbt);
        }
    }

    @Optional.Method(modid="opencomputers")
    protected void onChunkUnload_OC() {
        if (this.node() != null) {
            this.node().remove();
        }
    }

    @Optional.Method(modid="opencomputers")
    protected void invalidate_OC() {
        if (this.node() != null) {
            this.node().remove();
        }
    }

    @Optional.Method(modid="computercraft")
    public void attach(IComputerAccess computer) {
        if (this.attachedComputersCC == null) {
            this.attachedComputersCC = new CopyOnWriteArrayList();
        }
        this.attachedComputersCC.add(computer);
    }

    @Optional.Method(modid="computercraft")
    public void detach(IComputerAccess computer) {
        if (this.attachedComputersCC != null) {
            this.attachedComputersCC.remove(computer);
        }
    }

    @Optional.Method(modid="computercraft")
    public boolean equals(@Nullable IPeripheral other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof TileEntity) {
            TileEntity tother = (TileEntity)other;
            return tother.func_145831_w().equals(this.field_145850_b) && tother.func_174877_v().equals((Object)this.func_174877_v());
        }
        return false;
    }

    @Override
    @Optional.Method(modid="computercraft")
    public int peripheralPriority() {
        return 5;
    }

    @Override
    public boolean canConnectPeripheralOnSide(EnumFacing side) {
        return side == EnumFacing.DOWN || side == EnumFacing.UP;
    }
}

