/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.cc;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import java.util.Random;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.Optional;
import pl.asie.computronics.cc.TurtlePeripheralBase;
import pl.asie.computronics.cc.TurtleUpgradeBase;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.util.ParticleUtils;

public class ParticleTurtleUpgrade
extends TurtleUpgradeBase {
    public ParticleTurtleUpgrade(String id) {
        super(id);
    }

    public String getUnlocalisedAdjective() {
        return "Particle";
    }

    public ItemStack getCraftingItem() {
        return new ItemStack(Items.field_151065_br, 1, 0);
    }

    public IPeripheral createPeripheral(ITurtleAccess turtle, TurtleSide side) {
        return new ParticleTurtlePeripheral(turtle);
    }

    private static class ParticleTurtlePeripheral
    extends TurtlePeripheralBase {
        public ParticleTurtlePeripheral(ITurtleAccess access) {
            super(access);
        }

        public String getType() {
            return "particle";
        }

        @Optional.Method(modid="computercraft")
        public String[] getMethodNames() {
            return new String[]{"spawn"};
        }

        @Optional.Method(modid="computercraft")
        public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
            if (arguments.length < 4 || !(arguments[0] instanceof String)) {
                return new Object[]{false, "invalid arguments"};
            }
            for (int i = 1; i < arguments.length; ++i) {
                if (arguments[i] instanceof Double) continue;
                return new Object[]{false, "invalid argument " + i};
            }
            String name = (String)arguments[0];
            if (name.length() > Short.MAX_VALUE) {
                return new Object[]{false, "name too long"};
            }
            EnumParticleTypes particle = ParticleUtils.getParticleType(name);
            if (particle == null) {
                return new Object[]{false, "invalid particle type"};
            }
            double xOffset = MathHelper.func_151237_a((double)((Double)arguments[1]), (double)-65536.0, (double)65536.0);
            double yOffset = MathHelper.func_151237_a((double)((Double)arguments[2]), (double)-65536.0, (double)65536.0);
            double zOffset = MathHelper.func_151237_a((double)((Double)arguments[3]), (double)-65536.0, (double)65536.0);
            if (Config.FX_RANGE >= 0 && xOffset * xOffset + yOffset * yOffset + zOffset * zOffset > (double)(Config.FX_RANGE * Config.FX_RANGE)) {
                return new Object[]{false, "out of range"};
            }
            Random rng = this.access.getWorld().field_73012_v;
            double x = (double)this.access.getPosition().func_177958_n() + 0.5 + xOffset;
            double y = (double)this.access.getPosition().func_177956_o() + 0.5 + yOffset;
            double z = (double)this.access.getPosition().func_177952_p() + 0.5 + zOffset;
            double defaultv = rng.nextDouble() * 0.1;
            if (arguments.length >= 5) {
                defaultv = (Double)arguments[4];
            }
            double vx = defaultv * rng.nextGaussian();
            double vy = defaultv * rng.nextGaussian();
            double vz = defaultv * rng.nextGaussian();
            if (arguments.length >= 7) {
                vx = (Double)arguments[4];
                vy = (Double)arguments[5];
                vz = (Double)arguments[6];
            }
            ParticleUtils.sendParticlePacket(particle, this.access.getWorld(), x, y, z, vx, vy, vz);
            return new Object[]{true};
        }
    }
}

