/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.block;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.oc.block.IComputronicsEnvironmentBlock;
import pl.asie.computronics.oc.manual.IBlockWithDocumentation;
import pl.asie.computronics.tile.TileEntityPeripheralBase;
import pl.asie.computronics.util.internal.IBlockWithColor;
import pl.asie.lib.block.BlockBase;
import pl.asie.lib.util.ColorUtils;
import pl.asie.lib.util.WorldUtils;
import pl.asie.lib.util.internal.IColorable;

@Optional.InterfaceList(value={@Optional.Interface(iface="pl.asie.computronics.oc.block.IComputronicsEnvironmentBlock", modid="opencomputers")})
public abstract class BlockPeripheral
extends BlockBase
implements IComputronicsEnvironmentBlock,
IBlockWithDocumentation,
IBlockWithColor {
    protected String documentationName;

    public BlockPeripheral(String documentationName, BlockBase.Rotation rotation) {
        super(Material.field_151573_f, Computronics.instance, rotation);
        this.func_149647_a(Computronics.tab);
        this.documentationName = documentationName;
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ColorUtils.Color color;
        TileEntity tile = world.func_175625_s(pos);
        ItemStack heldItem = player.func_184586_b(hand);
        if (tile instanceof TileEntityPeripheralBase && ((TileEntityPeripheralBase)tile).canBeColored() && !heldItem.func_190926_b() && (color = ColorUtils.getColor(heldItem)) != null) {
            ((TileEntityPeripheralBase)tile).setColor(color.color);
            WorldUtils.notifyBlockUpdate(world, pos, state);
            return true;
        }
        return super.func_180639_a(world, pos, state, player, hand, side, hitX, hitY, hitZ);
    }

    public int getRenderColor(IBlockState state) {
        return 0xFFFFFF;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int colorMultiplier(IBlockState state, IBlockAccess world, BlockPos pos, int renderPass) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IColorable && ((IColorable)tile).canBeColored()) {
            return ((IColorable)tile).getColor();
        }
        return this.getRenderColor(state);
    }

    public boolean recolorBlock(World world, BlockPos pos, EnumFacing side, EnumDyeColor color) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IColorable && ((IColorable)tile).canBeColored()) {
            ((IColorable)tile).setColor(ColorUtils.fromColor((EnumDyeColor)color).color);
            WorldUtils.notifyBlockUpdate(world, pos);
            return true;
        }
        return super.recolorBlock(world, pos, side, color);
    }

    @Override
    @Deprecated
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos otherPos) {
        super.func_189540_a(state, world, pos, block, otherPos);
    }

    @Override
    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return true;
    }

    @Deprecated
    public boolean func_149721_r(IBlockState state) {
        return true;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    @Deprecated
    public boolean func_149637_q(IBlockState state) {
        return true;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return true;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return true;
    }

    @Override
    public String getDocumentationName(World world, BlockPos pos) {
        return this.documentationName;
    }

    @Override
    public String getDocumentationName(ItemStack stack) {
        return this.documentationName;
    }
}

