/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.block;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.item.block.IBlockWithDifferentColors;
import pl.asie.computronics.oc.manual.IBlockWithDocumentation;
import pl.asie.computronics.tile.TileAudioCable;
import pl.asie.computronics.util.internal.IBlockWithColor;
import pl.asie.lib.block.BlockBase;
import pl.asie.lib.util.ColorUtils;
import pl.asie.lib.util.WorldUtils;
import pl.asie.lib.util.internal.IColorable;

public class BlockAudioCable
extends BlockBase
implements IBlockWithDocumentation,
IBlockWithDifferentColors,
IBlockWithColor {
    private int connectionMask = 63;
    private int ImmibisMicroblocks_TransformableBlockMarker;
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    protected String documentationName = "audio_cable";

    public BlockAudioCable() {
        super(Material.field_151573_f, Computronics.instance, BlockBase.Rotation.NONE);
        this.func_149647_a(Computronics.tab);
        this.func_149663_c("computronics.audiocable");
    }

    public void setRenderMask(int m) {
        this.connectionMask = m;
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ColorUtils.Color color;
        TileEntity tile = world.func_175625_s(pos);
        ItemStack heldItem = player.func_184586_b(hand);
        if (tile instanceof TileAudioCable && !heldItem.func_190926_b() && (color = ColorUtils.getColor(heldItem)) != null) {
            ((TileAudioCable)tile).setColor(color.color);
            WorldUtils.notifyBlockUpdate(world, pos, state);
            return true;
        }
        return false;
    }

    public int getRenderColor() {
        return ColorUtils.Color.LightGray.color;
    }

    public int getRenderColor(IBlockState state) {
        return this.getRenderColor();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int colorMultiplier(IBlockState state, @Nullable IBlockAccess world, @Nullable BlockPos pos, int renderPass) {
        TileEntity tile;
        if (world != null && pos != null && (tile = world.func_175625_s(pos)) instanceof IColorable) {
            return ((IColorable)tile).getColor();
        }
        return this.getRenderColor(state);
    }

    public boolean recolorBlock(World world, BlockPos pos, EnumFacing side, EnumDyeColor color) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IColorable && ((IColorable)tile).canBeColored()) {
            ((IColorable)tile).setColor(ColorUtils.fromColor((EnumDyeColor)color).color);
            WorldUtils.notifyBlockUpdate(world, pos);
            return true;
        }
        return super.recolorBlock(world, pos, side, color);
    }

    @Override
    public boolean hasSubTypes() {
        return false;
    }

    @Override
    public int getColorFromItemstack(ItemStack stack, int pass) {
        return this.getRenderColor();
    }

    private int neighbors(IBlockAccess world, BlockPos pos) {
        int result = 0;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileAudioCable) {
            for (EnumFacing side : EnumFacing.field_82609_l) {
                if (!((TileAudioCable)tile).connectsAudio(side)) continue;
                result |= 1 << side.ordinal();
            }
        }
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    protected BlockStateContainer createActualBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{DOWN, UP, NORTH, SOUTH, WEST, EAST});
    }

    @Override
    @Deprecated
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity t = world.func_175625_s(pos);
        if (t instanceof TileAudioCable) {
            TileAudioCable tile = (TileAudioCable)t;
            return state.func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(tile.connectsAudio(EnumFacing.DOWN))).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(tile.connectsAudio(EnumFacing.UP))).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(tile.connectsAudio(EnumFacing.NORTH))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(tile.connectsAudio(EnumFacing.SOUTH))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(tile.connectsAudio(EnumFacing.WEST))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(tile.connectsAudio(EnumFacing.EAST)));
        }
        return state;
    }

    @Override
    @Deprecated
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos otherPos) {
        TileEntity t = world.func_175625_s(pos);
        if (t instanceof TileAudioCable) {
            ((TileAudioCable)t).updateConnections();
            world.func_184138_a(pos, state, state, 3);
        }
        super.func_189540_a(state, world, pos, block, otherPos);
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        TileEntity t = world.func_175625_s(pos);
        if (t instanceof TileAudioCable) {
            ((TileAudioCable)t).updateConnections();
        }
        super.onNeighborChange(world, pos, neighbor);
    }

    @Deprecated
    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return BoundingBox.getBox(this.neighbors(world, pos));
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return (this.connectionMask & 1 << side.ordinal()) != 0;
    }

    @Override
    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileAudioCable();
    }

    @Override
    public String getDocumentationName(World world, BlockPos pos) {
        return this.documentationName;
    }

    @Override
    public String getDocumentationName(ItemStack stack) {
        return this.documentationName;
    }

    private static class BoundingBox {
        private static final AxisAlignedBB[] bounds = new AxisAlignedBB[64];

        private BoundingBox() {
        }

        private static AxisAlignedBB getBox(int msk) {
            return bounds[msk];
        }

        static {
            for (int mask = 0; mask < 64; ++mask) {
                BoundingBox.bounds[mask] = new AxisAlignedBB((mask & 0x10) != 0 ? 0.0 : 0.3125, (mask & 1) != 0 ? 0.0 : 0.3125, (mask & 4) != 0 ? 0.0 : 0.3125, (mask & 0x20) != 0 ? 1.0 : 0.6875, (mask & 2) != 0 ? 1.0 : 0.6875, (mask & 8) != 0 ? 1.0 : 0.6875);
            }
        }
    }
}

