/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.quarry;

import com.rwtema.extrautils2.power.energy.EmptyEnergyHandler;
import com.rwtema.extrautils2.quarry.TileQuarry;
import com.rwtema.extrautils2.tile.XUTile;
import com.rwtema.extrautils2.utils.datastructures.NBTSerializable;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.IEnergyStorage;

public class TileQuarryProxy
extends XUTile {
    NBTSerializable.NBTEnum<EnumFacing> facing = this.registerNBT("facing", new NBTSerializable.NBTEnum<EnumFacing>(EnumFacing.DOWN));
    Boolean powered = null;

    public TileQuarryProxy() {
    }

    public TileQuarryProxy(EnumFacing facing) {
        this.facing.value = facing;
    }

    @Nullable
    public TileQuarry getParent() {
        EnumFacing value = (EnumFacing)this.facing.value;
        if (this.field_145850_b == null || this.field_174879_c == null) {
            return null;
        }
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(value));
        if (tile instanceof TileQuarry) {
            return (TileQuarry)tile;
        }
        return null;
    }

    @Override
    @Nullable
    public IEnergyStorage getEnergyHandler(EnumFacing facing) {
        return this.getEnergyHandler();
    }

    @Override
    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileQuarry parent = this.getParent();
        return parent != null && parent.onBlockActivated(worldIn, pos.func_177972_a((EnumFacing)this.facing.value), worldIn.func_180495_p(pos.func_177972_a((EnumFacing)this.facing.value)), playerIn, hand, heldItem, side, hitX, hitY, hitZ);
    }

    public IEnergyStorage getEnergyHandler() {
        TileQuarry parent = this.getParent();
        if (parent != null) {
            return parent.energy;
        }
        return EmptyEnergyHandler.INSTANCE;
    }

    @Override
    public void onNeighborBlockChange(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        this.powered = worldIn.func_175687_A(pos) > 0;
        TileQuarry parent = this.getParent();
        if (parent != null) {
            parent.redstoneDirty = true;
        }
    }

    public boolean isPowered() {
        if (this.powered == null) {
            this.powered = this.field_145850_b.func_175687_A(this.field_174879_c) > 0;
        }
        return this.powered;
    }
}

