/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.backend;

import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.entries.BlockEntry;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.backend.model.MutableModel;
import com.rwtema.extrautils2.backend.model.Transforms;
import com.rwtema.extrautils2.backend.model.XUBlockState;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.network.XUPacketBuffer;
import com.rwtema.extrautils2.render.IVertexBuffer;
import com.rwtema.extrautils2.tile.XUTile;
import com.rwtema.extrautils2.tile.tesr.ITESRHook;
import com.rwtema.extrautils2.utils.MCTimer;
import com.rwtema.extrautils2.utils.datastructures.NBTSerializable;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class XUBlockTESR
extends XUBlock {
    public XUBlockTESR() {
        BlockEntry.tileToBlocksMap.put(XUTESRTile.class, (Object)this);
    }

    public XUBlockTESR(Material materialIn) {
        super(materialIn);
        BlockEntry.tileToBlocksMap.put(XUTESRTile.class, (Object)this);
    }

    @Override
    public boolean getHasSubtypes() {
        return true;
    }

    public abstract BoxModel getWorldModel(@Nullable ItemStack var1, IBlockState var2, float var3);

    @Override
    @Nonnull
    public BoxModel getWorldModel(IBlockAccess world, BlockPos pos, @Nullable IBlockState state) {
        if (state == null) {
            state = world.func_180495_p(pos);
        }
        if (world == null) {
            return this.getWorldModel(null, state, 0.0f);
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof XUTESRTile)) {
            return this.getWorldModel(null, state, 0.0f);
        }
        XUTESRTile tile = (XUTESRTile)tileEntity;
        return this.getWorldModel(tile.NBTStack.getRaw(), state, 0.0f);
    }

    @Override
    public BoxModel getRenderModel(IBlockAccess world, BlockPos pos, @Nullable IBlockState state) {
        if (state == null) {
            state = world.func_180495_p(pos);
        }
        if (world == null) {
            return this.getWorldModel(null, state, 0.0f);
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof XUTESRTile)) {
            return this.getWorldModel(null, state, 0.0f);
        }
        XUTESRTile tile = (XUTESRTile)tileEntity;
        ItemStack raw = tile.NBTStack.getRaw();
        if (StackHelper.isNull(raw)) {
            return this.getWorldModel(null, state, 0.0f);
        }
        return this.getRenderModel(raw, state, 0.0f);
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public XUTESRTile createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new XUTESRTile();
    }

    @Override
    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BoxModel getInventoryModel(@Nullable ItemStack item) {
        return this.getRenderModel(item, (IBlockState)this.xuBlockState.getStateFromItemStack(item), MCTimer.renderTimer);
    }

    @SideOnly(value=Side.CLIENT)
    public abstract BoxModel getRenderModel(ItemStack var1, IBlockState var2, float var3);

    static {
        BlockEntry.registerTile(XUTESRTile.class);
    }

    public static class XUTESRTile
    extends XUTile
    implements ITESRHook {
        public NBTSerializable.NBTStack NBTStack = this.registerNBT("stack", new NBTSerializable.NBTStack());

        @Override
        public void handleDescriptionPacket(XUPacketBuffer packet) {
            this.NBTStack.setStackRaw(packet.readItemStack());
        }

        @Override
        public void addToDescriptionPacket(XUPacketBuffer packet) {
            packet.writeItemStack(this.NBTStack.getRaw());
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void render(IBlockAccess world, BlockPos pos, double x, double y, double z, float partialTicks, int destroyStage, IVertexBuffer renderer, BlockRendererDispatcher blockRenderer) {
            MutableModel model = new MutableModel(Transforms.blockTransforms);
            XUBlockState state = this.getBlockState();
            if (state == null) {
                return;
            }
            if (!(state.func_177230_c() instanceof XUBlockTESR)) {
                return;
            }
            BoxModel boxes = ((XUBlockTESR)state.func_177230_c()).getRenderModel(this.NBTStack.getRaw(), (IBlockState)state, MCTimer.renderTimer + (float)(this.hashCode() % 1024) / 1024.0f);
            boxes.loadIntoMutable(model, null);
            this.renderBakedModel(world, renderer, blockRenderer, model);
        }

        @Override
        public void onBlockPlacedBy(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack, XUBlock xuBlock) {
            super.onBlockPlacedBy(worldIn, pos, state, placer, stack, xuBlock);
            if (StackHelper.isNonNull(stack)) {
                this.NBTStack.setStackCopy(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
            }
        }

        @Override
        public Optional<ItemStack> getPickBlock(EntityPlayer player, RayTraceResult target) {
            return Optional.ofNullable(this.NBTStack.getCopy());
        }

        @Override
        public boolean harvestBlock(World worldIn, EntityPlayer player, BlockPos pos, XUBlock xuBlock, IBlockState state) {
            ItemStack copy = this.NBTStack.getCopy();
            if (StackHelper.isNonNull(copy)) {
                Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)copy);
            }
            return true;
        }
    }
}

