/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.api;

import java.lang.reflect.Array;
import java.util.Arrays;
import me.lucko.spark.api.statistic.Statistic;
import me.lucko.spark.api.statistic.types.DoubleStatistic;
import me.lucko.spark.api.statistic.types.GenericStatistic;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class AbstractStatistic<W extends Enum<W>>
implements Statistic<W> {
    private final String name;
    protected final W[] windows;

    protected AbstractStatistic(String name, Class<W> enumClass) {
        this.name = name;
        this.windows = (Enum[])enumClass.getEnumConstants();
    }

    @Override
    public @NonNull String name() {
        return this.name;
    }

    @Override
    public W[] getWindows() {
        return (Enum[])Arrays.copyOf(this.windows, this.windows.length);
    }

    public static abstract class Generic<T, W extends Enum<W>>
    extends AbstractStatistic<W>
    implements GenericStatistic<T, W> {
        private final Class<T> typeClass;

        public Generic(String name, Class<T> typeClass, Class<W> enumClass) {
            super(name, enumClass);
            this.typeClass = typeClass;
        }

        @Override
        public T[] poll() {
            Object[] values = (Object[])Array.newInstance(this.typeClass, this.windows.length);
            for (int i = 0; i < values.length; ++i) {
                values[i] = this.poll(this.windows[i]);
            }
            return values;
        }
    }

    public static abstract class Double<W extends Enum<W>>
    extends AbstractStatistic<W>
    implements DoubleStatistic<W> {
        public Double(String name, Class<W> enumClass) {
            super(name, enumClass);
        }

        @Override
        public double[] poll() {
            double[] values = new double[this.windows.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = this.poll(this.windows[i]);
            }
            return values;
        }
    }
}

