/*
 * Decompiled with CFR 0.152.
 */
package nikita488.zycraft.util;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import nikita488.zycraft.api.colorable.IColorable;
import nikita488.zycraft.block.QuartzCrystalClusterBlock;
import nikita488.zycraft.particle.SparkleParticleData;
import nikita488.zycraft.util.Color;
import nikita488.zycraft.util.ZYConstants;

public class ParticleUtils {
    public static void glowingBlock(BlockState state, World level, BlockPos pos, Random random) {
        ParticleUtils.glowingBlock(state, level, pos, random, -129);
    }

    public static void glowingColorableBlock(BlockState state, World level, BlockPos pos, Random random) {
        TileEntity blockEntity = level.func_175625_s(pos);
        if (blockEntity instanceof IColorable) {
            ParticleUtils.glowingBlock(state, level, pos, random, Color.rgba(((IColorable)blockEntity).getColor(state, (IBlockDisplayReader)level, pos), 192));
        }
    }

    public static void glowingBlock(BlockState state, World level, BlockPos pos, Random random, int rgba) {
        SparkleParticleData data = SparkleParticleData.builder().color(rgba).lifetimeFactor(6).sizeFactor(0.5f).build();
        double offset = 0.5625;
        for (Direction side : ZYConstants.DIRECTIONS) {
            BlockPos relativePos;
            BlockState relativeState;
            if (random.nextFloat() > 0.15f || state == (relativeState = level.func_180495_p(relativePos = pos.func_177972_a(side))) || relativeState.func_235785_r_((IBlockReader)level, relativePos)) continue;
            Direction.Axis axis = side.func_176740_k();
            double xOffset = axis == Direction.Axis.X ? 0.5 + offset * (double)side.func_82601_c() : (double)random.nextFloat();
            double yOffset = axis == Direction.Axis.Y ? 0.5 + offset * (double)side.func_96559_d() : (double)random.nextFloat();
            double zOffset = axis == Direction.Axis.Z ? 0.5 + offset * (double)side.func_82599_e() : (double)random.nextFloat();
            level.func_195594_a((IParticleData)data, (double)pos.func_177958_n() + xOffset, (double)pos.func_177956_o() + yOffset, (double)pos.func_177952_p() + zOffset, 0.0, 0.0, 0.0);
        }
    }

    public static void quartzCrystalCluster(BlockState state, World level, BlockPos pos, Random random) {
        SparkleParticleData data = SparkleParticleData.builder().color(-128).lifetimeFactor(6).sizeFactor(0.5f).build();
        float size = 0.375f;
        float height = 0.6875f;
        Direction facing = (Direction)state.func_177229_b((Property)QuartzCrystalClusterBlock.FACING);
        double xOffset = ParticleUtils.getOffset(random, facing, Direction.Axis.X, size, height);
        double yOffset = ParticleUtils.getOffset(random, facing, Direction.Axis.Y, size, height);
        double zOffset = ParticleUtils.getOffset(random, facing, Direction.Axis.Z, size, height);
        level.func_195594_a((IParticleData)data, (double)pos.func_177958_n() + xOffset, (double)pos.func_177956_o() + yOffset, (double)pos.func_177952_p() + zOffset, 0.0, 0.0, 0.0);
    }

    private static double getOffset(Random random, Direction facing, Direction.Axis axis, float size, float height) {
        if (facing.func_176740_k() == axis) {
            if (facing.func_176743_c() == Direction.AxisDirection.POSITIVE) {
                return random.nextFloat() * height;
            }
            return 1.0 - (double)(random.nextFloat() * height);
        }
        return 0.5 + ((double)random.nextFloat() - 0.5) * (double)size;
    }
}

