/*
 * Decompiled with CFR 0.152.
 */
package nikita488.zycraft.util;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import nikita488.zycraft.util.ItemStackUtils;

public class FluidUtils {
    public static void transferFromTo(IFluidHandler from, IFluidHandler to, int amount) {
        FluidUtils.transferFromTo(from, to, amount, 1000);
    }

    public static void transferFromTo(IFluidHandler from, IFluidHandler to, int amount, int maxDrain) {
        if (amount > 0) {
            FluidUtils.tryTransfer(from, to, amount, maxDrain);
        } else if (amount < 0) {
            FluidUtils.tryTransfer(to, from, -amount, maxDrain);
        }
    }

    private static void tryTransfer(IFluidHandler from, IFluidHandler to, int amount, int maxDrain) {
        FluidStack drained = from.drain(Math.min(amount, maxDrain), IFluidHandler.FluidAction.SIMULATE);
        int filled = to.fill(drained, IFluidHandler.FluidAction.SIMULATE);
        if (filled <= 0) {
            return;
        }
        drained = from.drain(filled, IFluidHandler.FluidAction.EXECUTE);
        to.fill(drained, IFluidHandler.FluidAction.EXECUTE);
    }

    public static Optional<IFluidHandlerItem> getItemFluidHandler(ItemStack stack) {
        if (stack.func_190926_b()) {
            return Optional.empty();
        }
        stack = ItemStackUtils.copy(stack, 1);
        return stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).resolve();
    }

    public static boolean canPlaceFluid(World level, BlockPos pos, BlockState state, Fluid fluid) {
        return state.func_177230_c() instanceof ILiquidContainer && ((ILiquidContainer)state.func_177230_c()).func_204510_a((IBlockReader)level, pos, state, fluid);
    }

    public static boolean tryPlaceFluid(FluidStack stack, @Nullable PlayerEntity player, World level, BlockPos pos, @Nullable BlockRayTraceResult hitResult) {
        Fluid fluid = stack.getFluid();
        if (fluid instanceof FlowingFluid) {
            boolean canPlace;
            FluidAttributes attributes = fluid.getAttributes();
            FluidState fluidState = attributes.getStateForPlacement((IBlockDisplayReader)level, pos, stack);
            if (fluidState.func_206888_e() || !fluidState.func_206889_d() || !attributes.canBePlacedInWorld((IBlockDisplayReader)level, pos, fluidState)) {
                return false;
            }
            BlockState blockState = level.func_180495_p(pos);
            boolean replaceable = blockState.func_227032_a_(fluid);
            boolean bl = canPlace = blockState.func_196958_f() || replaceable || FluidUtils.canPlaceFluid(level, pos, blockState, fluid);
            if (!canPlace) {
                return hitResult != null && FluidUtils.tryPlaceFluid(stack, player, level, hitResult.func_216350_a().func_177972_a(hitResult.func_216354_b()), null);
            }
            if (level.func_230315_m_().func_236040_e_() && attributes.doesVaporize((IBlockDisplayReader)level, pos, stack)) {
                attributes.vaporize(player, level, pos, stack);
                return true;
            }
            if (FluidUtils.canPlaceFluid(level, pos, blockState, fluid)) {
                ((ILiquidContainer)blockState.func_177230_c()).func_204509_a((IWorld)level, pos, blockState, ((FlowingFluid)fluid).func_207204_a(false));
                level.func_184133_a(player, pos, attributes.getEmptySound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                return true;
            }
            if (!level.func_201670_d() && replaceable && !blockState.func_185904_a().func_76224_d()) {
                level.func_175655_b(pos, true);
            }
            if (!level.func_180501_a(pos, attributes.getBlock((IBlockDisplayReader)level, pos, fluidState), 11) && !blockState.func_204520_s().func_206889_d()) {
                return false;
            }
            level.func_184133_a(player, pos, attributes.getEmptySound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public static boolean voidFluid(World level, BlockPos pos, Predicate<FluidState> predicate) {
        if (!predicate.test(level.func_204610_c(pos))) {
            return false;
        }
        BlockState state = level.func_180495_p(pos);
        if (state.func_177230_c() instanceof IBucketPickupHandler && ((IBucketPickupHandler)state.func_177230_c()).func_204508_a((IWorld)level, pos, state) != Fluids.field_204541_a) {
            return true;
        }
        if (!(state.func_177230_c() instanceof FlowingFluidBlock)) {
            Material material = state.func_185904_a();
            if (material != Material.field_203243_f && material != Material.field_204868_h) {
                return false;
            }
            Block.func_220059_a((BlockState)state, (IWorld)level, (BlockPos)pos, state.hasTileEntity() ? level.func_175625_s(pos) : null);
        }
        level.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        return true;
    }
}

