/*
 * Decompiled with CFR 0.152.
 */
package nikita488.zycraft.network;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.network.NetworkEvent;
import nikita488.zycraft.init.ZYRegistries;
import nikita488.zycraft.multiblock.MultiBlock;
import nikita488.zycraft.multiblock.MultiManager;
import nikita488.zycraft.multiblock.MultiType;

public class AddMultiPacket {
    private final MultiType<?> type;
    private final ChunkPos mainChunk;
    private final int id;
    private MultiBlock multiBlock;
    private PacketBuffer buffer;

    public AddMultiPacket(MultiBlock multiBlock) {
        this.type = multiBlock.type();
        this.mainChunk = multiBlock.mainChunk();
        this.id = multiBlock.id();
        this.multiBlock = multiBlock;
    }

    public AddMultiPacket(PacketBuffer buffer) {
        this.type = (MultiType)buffer.readRegistryIdUnsafe(ZYRegistries.MULTI_TYPES.get());
        this.mainChunk = new ChunkPos(buffer.func_150792_a(), buffer.func_150792_a());
        this.id = buffer.func_150792_a();
        this.buffer = buffer;
    }

    public static AddMultiPacket decode(PacketBuffer buffer) {
        return new AddMultiPacket(buffer);
    }

    public static void encode(AddMultiPacket packet, PacketBuffer buffer) {
        buffer.writeRegistryIdUnsafe(ZYRegistries.MULTI_TYPES.get(), packet.type());
        buffer.func_150787_b(packet.mainChunk().field_77276_a);
        buffer.func_150787_b(packet.mainChunk().field_77275_b);
        buffer.func_150787_b(packet.id());
        packet.multiBlock.encode(buffer);
    }

    public static boolean handle(AddMultiPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Optional level = (Optional)LogicalSidedProvider.CLIENTWORLD.get(((NetworkEvent.Context)context.get()).getDirection().getReceptionSide());
            MultiBlock multiBlock = level.map(clientLevel -> packet.type().create((World)clientLevel, packet.mainChunk())).orElse(null);
            if (multiBlock == null) {
                return;
            }
            multiBlock.setID(packet.id());
            multiBlock.decode(packet.buffer());
            multiBlock.initChildBlocks();
            MultiManager.getInstance().addMultiBlock(multiBlock, MultiBlock.AddingReason.LOADED);
        });
        return true;
    }

    public MultiType<?> type() {
        return this.type;
    }

    public ChunkPos mainChunk() {
        return this.mainChunk;
    }

    public int id() {
        return this.id;
    }

    public PacketBuffer buffer() {
        return this.buffer;
    }
}

