/*
 * Decompiled with CFR 0.152.
 */
package nikita488.zycraft.multiblock.inventory;

import java.util.EnumMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.EmptyHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;
import nikita488.zycraft.block.state.properties.ItemIOMode;
import nikita488.zycraft.multiblock.inventory.IMultiItemIOHandler;

public class MultiItemIOHandler
extends ItemStackHandler
implements IMultiItemIOHandler {
    private final EnumMap<ItemIOMode, IItemHandlerModifiable> itemHandlers = new EnumMap(ItemIOMode.class);
    private final int[] activeModes = new int[ItemIOMode.VALUES.length];
    private int inputCount;
    private int outputCount;

    public MultiItemIOHandler() {
        this.itemHandlers.put(ItemIOMode.ANY, this);
    }

    public MultiItemIOHandler(int size) {
        super(size);
        this.itemHandlers.put(ItemIOMode.ANY, this);
    }

    public MultiItemIOHandler(NonNullList<ItemStack> stacks) {
        super(stacks);
        this.itemHandlers.put(ItemIOMode.ANY, this);
    }

    @Override
    public boolean isSupported(ItemIOMode mode) {
        return this.itemHandlers.containsKey((Object)mode);
    }

    @Override
    public IItemHandler access(ItemIOMode mode) {
        IItemHandlerModifiable handler = this.itemHandlers.get((Object)mode);
        return handler != null ? handler : EmptyHandler.INSTANCE;
    }

    @Override
    public void setActive(ItemIOMode mode) {
        int n = mode.ordinal();
        this.activeModes[n] = this.activeModes[n] + 1;
    }

    @Override
    public void setInactive(ItemIOMode mode) {
        if (this.isActive(mode)) {
            int n = mode.ordinal();
            this.activeModes[n] = this.activeModes[n] - 1;
        }
    }

    @Override
    public boolean isActive(ItemIOMode mode) {
        return this.activeModes[mode.ordinal()] > 0;
    }

    public MultiItemIOHandler input(int slot) {
        return this.input(slot, slot + 1);
    }

    public MultiItemIOHandler input(int minSlot, int maxSlotExclusive) {
        if (this.inputCount > 1) {
            return this;
        }
        if (this.inputCount > 0) {
            this.itemHandlers.put(ItemIOMode.IN1, this.itemHandlers.get((Object)ItemIOMode.ALL_IN));
            this.itemHandlers.put(ItemIOMode.IN2, (IItemHandlerModifiable)new RangedWrapper((IItemHandlerModifiable)this, minSlot, maxSlotExclusive));
            this.itemHandlers.put(ItemIOMode.ALL_IN, (IItemHandlerModifiable)new CombinedInvWrapper(new IItemHandlerModifiable[]{this.itemHandlers.get((Object)ItemIOMode.IN1), this.itemHandlers.get((Object)ItemIOMode.IN2)}));
        } else {
            this.itemHandlers.put(ItemIOMode.ALL_IN, (IItemHandlerModifiable)new RangedWrapper((IItemHandlerModifiable)this, minSlot, maxSlotExclusive));
        }
        ++this.inputCount;
        return this;
    }

    public MultiItemIOHandler output(int slot) {
        return this.output(slot, slot + 1);
    }

    public MultiItemIOHandler output(int minSlot, int maxSlotExclusive) {
        if (this.outputCount > 1) {
            return this;
        }
        if (this.outputCount > 0) {
            this.itemHandlers.put(ItemIOMode.OUT1, this.itemHandlers.get((Object)ItemIOMode.ALL_OUT));
            this.itemHandlers.put(ItemIOMode.OUT2, (IItemHandlerModifiable)new RangedWrapper((IItemHandlerModifiable)this, minSlot, maxSlotExclusive));
            this.itemHandlers.put(ItemIOMode.ALL_OUT, (IItemHandlerModifiable)new CombinedInvWrapper(new IItemHandlerModifiable[]{this.itemHandlers.get((Object)ItemIOMode.OUT1), this.itemHandlers.get((Object)ItemIOMode.OUT2)}));
        } else {
            this.itemHandlers.put(ItemIOMode.ALL_OUT, (IItemHandlerModifiable)new RangedWrapper((IItemHandlerModifiable)this, minSlot, maxSlotExclusive));
        }
        ++this.outputCount;
        return this;
    }
}

