/*
 * Decompiled with CFR 0.152.
 */
package nikita488.zycraft.multiblock.former;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBiomeReader;
import net.minecraft.world.IBlockReader;
import nikita488.zycraft.multiblock.MultiBlock;
import nikita488.zycraft.multiblock.child.IMultiChild;
import nikita488.zycraft.multiblock.child.IMultiChildMatcher;
import nikita488.zycraft.multiblock.child.MultiChildType;
import nikita488.zycraft.util.Cuboid6i;

public class MultiPattern {
    public static final int NULL = -2;
    public static final int ALWAYS_MATCHES = -1;
    private final int[][][] pattern;
    private final IMultiChildMatcher[] matchers;

    private MultiPattern(int[][][] pattern, IMultiChildMatcher[] matchers) {
        this.pattern = pattern;
        this.matchers = matchers;
    }

    public static Builder builder(int width, int height, int depth) {
        return new Builder(width, height, depth);
    }

    public boolean process(BlockPos basePos, MultiChildProcessor processor) {
        BlockPos.Mutable processingPos = basePos.func_239590_i_();
        for (int x = 0; x < this.width(); ++x) {
            for (int y = 0; y < this.height(); ++y) {
                for (int z = 0; z < this.depth(); ++z) {
                    if (processor.test(this.pattern[x][y][z], (BlockPos)processingPos.func_239621_a_((Vector3i)basePos, x, y, z))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void convert(IBiomeReader accessor, BlockPos basePos, MultiBlock multiBlock) {
        this.process(basePos, (matcherIndex, pos) -> {
            if (matcherIndex < -1) {
                return true;
            }
            if (!(accessor.func_175625_s(pos) instanceof IMultiChild)) {
                MultiChildType.convert(accessor, pos);
            }
            multiBlock.addChildBlock(pos);
            return true;
        });
    }

    public boolean matches(IBlockReader getter, BlockPos basePos) {
        return this.process(basePos, (matcherIndex, pos) -> matcherIndex < 0 || this.matchers[matcherIndex].matches(getter, pos));
    }

    public int width() {
        return this.pattern.length;
    }

    public int height() {
        return this.pattern[0].length;
    }

    public int depth() {
        return this.pattern[0][0].length;
    }

    public static final class Builder {
        private final int[][][] pattern;
        private final ObjectList<IMultiChildMatcher> matchers = new ObjectArrayList();

        private Builder(int width, int height, int depth) {
            this.pattern = new int[width][height][depth];
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    for (int z = 0; z < depth; ++z) {
                        this.block(x, y, z, -2);
                    }
                }
            }
        }

        public int indexOf(IMultiChildMatcher matcher) {
            if (matcher == IMultiChildMatcher.ALWAYS_MATCHES) {
                return -1;
            }
            int matcherIndex = this.matchers.indexOf((Object)matcher);
            if (matcherIndex != -1) {
                return matcherIndex;
            }
            this.matchers.add((Object)matcher);
            return this.matchers.size() - 1;
        }

        public Builder block(int x, int y, int z, int matcherIndex) {
            this.pattern[x][y][z] = matcherIndex;
            return this;
        }

        public Builder cuboid(IMultiChildMatcher matcher) {
            return this.cuboid(0, 0, 0, this.width() - 1, this.height() - 1, this.depth() - 1, matcher);
        }

        public Builder cuboid(Cuboid6i cuboid, IMultiChildMatcher matcher) {
            return this.cuboid(cuboid.minX(), cuboid.minY(), cuboid.minZ(), cuboid.maxX(), cuboid.maxY(), cuboid.maxZ(), matcher);
        }

        public Builder cuboid(int x1, int y1, int z1, int x2, int y2, int z2, IMultiChildMatcher matcher) {
            int matcherIndex = this.indexOf(matcher);
            for (int x = x1; x <= x2; ++x) {
                for (int y = y1; y <= y2; ++y) {
                    for (int z = z1; z <= z2; ++z) {
                        this.block(x, y, z, matcherIndex);
                    }
                }
            }
            return this;
        }

        public Builder corners(IMultiChildMatcher matcher) {
            return this.corners(0, 0, 0, this.width() - 1, this.height() - 1, this.depth() - 1, matcher);
        }

        public Builder corners(Cuboid6i cuboid, IMultiChildMatcher matcher) {
            return this.corners(cuboid.minX(), cuboid.minY(), cuboid.minZ(), cuboid.maxX(), cuboid.maxY(), cuboid.maxZ(), matcher);
        }

        public Builder corners(int x1, int y1, int z1, int x2, int y2, int z2, IMultiChildMatcher matcher) {
            int matcherIndex = this.indexOf(matcher);
            this.block(x1, y1, z1, matcherIndex);
            this.block(x1, y1, z2, matcherIndex);
            this.block(x1, y2, z1, matcherIndex);
            this.block(x1, y2, z2, matcherIndex);
            this.block(x2, y1, z1, matcherIndex);
            this.block(x2, y1, z2, matcherIndex);
            this.block(x2, y2, z1, matcherIndex);
            this.block(x2, y2, z2, matcherIndex);
            return this;
        }

        public Builder edges(IMultiChildMatcher matcher) {
            return this.edges(0, 0, 0, this.width() - 1, this.height() - 1, this.depth() - 1, matcher);
        }

        public Builder edges(Cuboid6i cuboid, IMultiChildMatcher matcher) {
            return this.edges(cuboid.minX(), cuboid.minY(), cuboid.minZ(), cuboid.maxX(), cuboid.maxY(), cuboid.maxZ(), matcher);
        }

        public Builder edges(int x1, int y1, int z1, int x2, int y2, int z2, IMultiChildMatcher matcher) {
            int matcherIndex = this.indexOf(matcher);
            for (int x = x1 + 1; x <= x2 - 1; ++x) {
                this.block(x, y1, z1, matcherIndex);
                this.block(x, y1, z2, matcherIndex);
                this.block(x, y2, z1, matcherIndex);
                this.block(x, y2, z2, matcherIndex);
            }
            for (int y = y1 + 1; y <= y2 - 1; ++y) {
                this.block(x1, y, z1, matcherIndex);
                this.block(x1, y, z2, matcherIndex);
                this.block(x2, y, z1, matcherIndex);
                this.block(x2, y, z2, matcherIndex);
            }
            for (int z = z1 + 1; z <= z2 - 1; ++z) {
                this.block(x1, y1, z, matcherIndex);
                this.block(x1, y2, z, matcherIndex);
                this.block(x2, y1, z, matcherIndex);
                this.block(x2, y2, z, matcherIndex);
            }
            return this;
        }

        public Builder frame(IMultiChildMatcher matcher) {
            return this.frame(0, 0, 0, this.width() - 1, this.height() - 1, this.depth() - 1, matcher);
        }

        public Builder frame(Cuboid6i cuboid, IMultiChildMatcher matcher) {
            return this.frame(cuboid.minX(), cuboid.minY(), cuboid.minZ(), cuboid.maxX(), cuboid.maxY(), cuboid.maxZ(), matcher);
        }

        public Builder frame(int x1, int y1, int z1, int x2, int y2, int z2, IMultiChildMatcher matcher) {
            this.corners(x1, y1, z1, x2, y2, z2, matcher);
            this.edges(x1, y1, z1, x2, y2, z2, matcher);
            return this;
        }

        public Builder faces(IMultiChildMatcher matcher) {
            return this.faces(0, 0, 0, this.width() - 1, this.height() - 1, this.depth() - 1, matcher);
        }

        public Builder faces(Cuboid6i cuboid, IMultiChildMatcher matcher) {
            return this.faces(cuboid.minX(), cuboid.minY(), cuboid.minZ(), cuboid.maxX(), cuboid.maxY(), cuboid.maxZ(), matcher);
        }

        public Builder faces(int x1, int y1, int z1, int x2, int y2, int z2, IMultiChildMatcher matcher) {
            this.cuboid(x1 + 1, y1, z1 + 1, x2 - 1, y1, z2 - 1, matcher);
            this.cuboid(x1 + 1, y2, z1 + 1, x2 - 1, y2, z2 - 1, matcher);
            this.cuboid(x1 + 1, y1 + 1, z1, x2 - 1, y2 - 1, z1, matcher);
            this.cuboid(x1 + 1, y1 + 1, z2, x2 - 1, y2 - 1, z2, matcher);
            this.cuboid(x1, y1 + 1, z1 + 1, x1, y2 - 1, z2 - 1, matcher);
            this.cuboid(x2, y1 + 1, z1 + 1, x2, y2 - 1, z2 - 1, matcher);
            return this;
        }

        public Builder shell(IMultiChildMatcher matcher) {
            return this.shell(0, 0, 0, this.width() - 1, this.height() - 1, this.depth() - 1, matcher);
        }

        public Builder shell(Cuboid6i cuboid, IMultiChildMatcher matcher) {
            return this.shell(cuboid.minX(), cuboid.minY(), cuboid.minZ(), cuboid.maxX(), cuboid.maxY(), cuboid.maxZ(), matcher);
        }

        public Builder shell(int x1, int y1, int z1, int x2, int y2, int z2, IMultiChildMatcher matcher) {
            this.frame(x1, y1, z1, x2, y2, z2, matcher);
            this.faces(x1, y1, z1, x2, y2, z2, matcher);
            return this;
        }

        public MultiPattern build() {
            return new MultiPattern(this.pattern, (IMultiChildMatcher[])this.matchers.toArray((Object[])new IMultiChildMatcher[0]));
        }

        public int width() {
            return this.pattern.length;
        }

        public int height() {
            return this.pattern[0].length;
        }

        public int depth() {
            return this.pattern[0][0].length;
        }
    }

    @FunctionalInterface
    public static interface MultiChildProcessor {
        public boolean test(int var1, BlockPos var2);
    }
}

