/*
 * Decompiled with CFR 0.152.
 */
package nikita488.zycraft.multiblock.fluid;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import nikita488.zycraft.client.renderer.multiblock.MultiFluidRenderer;
import nikita488.zycraft.multiblock.fluid.IMultiFluidHandler;
import nikita488.zycraft.multiblock.fluid.IMultiFluidTank;
import nikita488.zycraft.util.Cuboid6i;
import nikita488.zycraft.util.FluidUtils;
import nikita488.zycraft.util.MathUtils;

public class MultiFluidTank
extends FluidTank
implements IMultiFluidHandler,
IMultiFluidTank {
    public static final int AMOUNT_PER_BLOCK = 16000;
    private final Cuboid6i bounds;
    private final BlockPos center;
    private final int area;
    private final Level[] levels;
    private FluidStack lastFluid = FluidStack.EMPTY;

    public MultiFluidTank(Cuboid6i bounds) {
        this(bounds, stack -> true);
    }

    public MultiFluidTank(Cuboid6i bounds, Predicate<FluidStack> validator) {
        super(bounds.volume() * 16000, validator);
        this.bounds = bounds;
        this.center = bounds.center();
        this.area = bounds.width() * bounds.depth();
        this.levels = new Level[bounds.height() + 1];
        for (int i = 0; i < this.levels.length; ++i) {
            this.levels[i] = new Level(i);
        }
    }

    public void tick() {
        if (!this.lastFluid.isEmpty() && this.fluid.getAmount() != this.lastFluid.getAmount()) {
            this.lastFluid.setAmount(MathUtils.lerp(0.1f, this.lastFluid.getAmount(), this.fluid.getAmount()));
        }
    }

    @Override
    public IMultiFluidHandler.Level level(int valvePosY) {
        int level = Math.max(valvePosY, this.bounds.minY()) - this.bounds.minY();
        return this.levels[Math.min(level, this.levels.length - 1)];
    }

    @Override
    public int getArea() {
        return this.area;
    }

    @Override
    public float getPressure(int valvePosY) {
        float compressedPressure = (float)(this.fluid.getAmount() - this.capacity) / (float)this.area;
        float heightPressure = this.getFluidPosY() - (float)Math.max(valvePosY, this.bounds.minY());
        return Math.max(0.0f, Math.max(compressedPressure, heightPressure * 100.0f));
    }

    @Override
    public int getArea(int tank) {
        return this.getArea();
    }

    @Override
    public float getPressure(int tank, int valvePosY) {
        return this.getPressure(valvePosY);
    }

    public void onContentsChanged() {
        if (!this.fluid.isFluidEqual(this.lastFluid)) {
            this.lastFluid = this.fluid.copy();
            this.onFluidChanged();
            this.sendUpdated();
        } else if (Math.abs(this.fluid.getAmount() - this.lastFluid.getAmount()) > 250) {
            this.lastFluid.setAmount(this.fluid.getAmount());
            this.sendUpdated();
        }
    }

    public void sendUpdated() {
    }

    public void onFluidChanged() {
    }

    public void render(MatrixStack stack, IRenderTypeBuffer source, IBlockDisplayReader getter, float partialTicks) {
        if (this.lastFluid.isEmpty() || this.capacity <= 0) {
            return;
        }
        stack.func_227860_a_();
        stack.func_227861_a_((double)(-this.bounds.minX() + 1), (double)(-this.bounds.minY() + 1), (double)(-this.bounds.minZ() + 1));
        MultiFluidRenderer.render(stack, source, this.lastFluid, this.bounds, 1.0f, (float)this.lastFluid.getAmount() / (float)this.capacity, getter, this.center);
        stack.func_227865_b_();
    }

    public float getFluidPosY() {
        return (float)this.bounds.minY() + Math.min((float)this.fluid.getAmount() / (float)(this.area * 16000), (float)this.bounds.height());
    }

    public MultiFluidTank readFromNBT(CompoundNBT tag) {
        if (tag.func_150297_b("Fluid", 10)) {
            this.setFluid(FluidStack.loadFluidStackFromNBT((CompoundNBT)tag.func_74775_l("Fluid")));
        }
        return this;
    }

    public CompoundNBT writeToNBT(CompoundNBT tag) {
        if (!this.fluid.isEmpty()) {
            tag.func_218657_a("Fluid", (INBT)this.fluid.writeToNBT(new CompoundNBT()));
        }
        return tag;
    }

    public void decode(PacketBuffer buffer) {
        this.setFluid(buffer.readFluidStack());
    }

    public void decodeUpdate(PacketBuffer buffer) {
        this.fluid = buffer.readFluidStack();
        if (!this.fluid.isFluidEqual(this.lastFluid)) {
            this.lastFluid = new FluidStack(this.fluid, 1);
            this.onFluidChanged();
        }
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeFluidStack(this.fluid);
    }

    public void setFluid(FluidStack stack) {
        super.setFluid(stack);
        if (stack.isFluidEqual(this.lastFluid)) {
            return;
        }
        this.lastFluid = stack.copy();
        this.onFluidChanged();
    }

    public MultiFluidTank setCapacity(int capacity) {
        super.setCapacity(capacity);
        return this;
    }

    public MultiFluidTank setValidator(Predicate<FluidStack> validator) {
        super.setValidator(validator);
        return this;
    }

    public class Level
    implements IMultiFluidHandler.Level,
    IMultiFluidTank.Level {
        private final MultiFluidTank tank;
        private final int inaccessibleAmount;

        public Level(int index) {
            this.tank = MultiFluidTank.this;
            this.inaccessibleAmount = Math.max(0, index) * this.tank.getArea() * 16000;
        }

        @Override
        public IMultiFluidHandler parentTank() {
            return this.tank;
        }

        @Override
        public void applyPressure(IMultiFluidHandler.Level targetLevel, int valvePosY) {
            IMultiFluidHandler targetTank = targetLevel.parentTank();
            float diff = this.tank.getPressure(valvePosY) - targetTank.getPressure(0, valvePosY);
            int targetAmount = targetTank.getFluidInTank(0).getAmount();
            int targetCapacity = targetTank.getTankCapacity(0);
            int targetArea = targetTank.getArea(0);
            int area = Math.min(this.tank.getArea(), targetArea);
            int amount = (float)this.tank.getFluidAmount() <= (float)this.tank.getArea() * 1.5f && diff > 0.0f ? 1 : ((float)targetAmount <= (float)targetArea * 1.5f && diff < 0.0f ? -1 : (this.tank.getFluidAmount() < this.tank.getCapacity() && targetAmount < targetCapacity ? (int)(diff * (float)area * 100.0f) : (int)(diff * (float)area)));
            FluidUtils.transferFromTo(this, targetLevel, amount);
        }

        @Nonnull
        public FluidStack getFluid() {
            return !this.tank.isEmpty() ? (FluidStack)Util.func_200696_a((Object)this.tank.getFluid().copy(), stack -> stack.shrink(this.inaccessibleAmount)) : FluidStack.EMPTY;
        }

        public int getFluidAmount() {
            return Math.max(0, this.tank.getFluidAmount() - this.inaccessibleAmount);
        }

        public int getCapacity() {
            return Math.max(0, this.tank.getCapacity() - this.inaccessibleAmount);
        }

        public boolean isFluidValid(FluidStack stack) {
            return this.tank.isFluidValid(stack);
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return this.getFluid();
        }

        public int getTankCapacity(int tank) {
            return this.getCapacity();
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return this.isFluidValid(stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return this.tank.fill(resource, action);
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return !resource.isEmpty() && resource.isFluidEqual(this.tank.getFluid()) ? this.drain(resource.getAmount(), action) : FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return this.tank.drain(Math.min(this.getFluidAmount(), maxDrain), action);
        }
    }
}

