/*
 * Decompiled with CFR 0.152.
 */
package nikita488.zycraft.multiblock.child.tile;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.EmptyHandler;
import nikita488.zycraft.block.state.properties.ItemIOMode;
import nikita488.zycraft.multiblock.MultiBlock;
import nikita488.zycraft.multiblock.child.block.ItemIOBlock;
import nikita488.zycraft.multiblock.child.tile.MultiInterfaceTile;
import nikita488.zycraft.multiblock.inventory.IMultiItemIOHandler;

public class ItemIOTile
extends MultiInterfaceTile
implements ITickableTileEntity,
IItemHandlerModifiable {
    private final Supplier<ItemIOMode> mode = () -> (ItemIOMode)((Object)((Object)this.func_195044_w().func_177229_b(ItemIOBlock.IO_MODE)));
    private LazyOptional<IItemHandler> capability = LazyOptional.empty();
    private IItemHandler inventory = EmptyHandler.INSTANCE;
    @Nullable
    private IMultiItemIOHandler ioHandler;

    public ItemIOTile(TileEntityType<?> type) {
        super(type);
    }

    @Override
    public ActionResultType use(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hitResult) {
        if (!player.func_225608_bj_()) {
            return super.use(state, level, pos, player, hand, hitResult);
        }
        this.nextMode(state);
        return ActionResultType.func_233537_a_((boolean)level.func_201670_d());
    }

    private void nextMode(BlockState state) {
        BlockState lastState = state;
        state = (BlockState)state.func_235896_a_(ItemIOBlock.IO_MODE);
        while (!this.isSupported((ItemIOMode)((Object)state.func_177229_b(ItemIOBlock.IO_MODE)))) {
            state = (BlockState)state.func_235896_a_(ItemIOBlock.IO_MODE);
        }
        if (state == lastState) {
            return;
        }
        if (this.ioHandler != null) {
            ItemIOMode newMode = (ItemIOMode)((Object)state.func_177229_b(ItemIOBlock.IO_MODE));
            this.ioHandler.setInactive(this.mode.get());
            this.ioHandler.setActive(newMode);
            this.capability.invalidate();
            this.inventory = this.ioHandler.access(newMode);
            this.capability = LazyOptional.of(() -> this);
        }
        this.field_145850_b.func_175656_a(this.field_174879_c, state);
    }

    private boolean isSupported(ItemIOMode mode) {
        if (!this.capability.isPresent()) {
            return true;
        }
        if (this.ioHandler != null) {
            return this.ioHandler.isSupported(mode);
        }
        return mode == ItemIOMode.ANY;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.func_201670_d() && this.capability.isPresent()) {
            this.update();
        }
    }

    @Override
    protected void processRelativePos(BlockPos pos, Direction side) {
        if (this.mode.get().isOutput()) {
            this.eject(pos, side);
        }
    }

    private void eject(BlockPos pos, Direction side) {
        TileEntity blockEntity = this.field_145850_b.func_175625_s(pos);
        if (blockEntity == null) {
            return;
        }
        LazyOptional capability = blockEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.func_176734_d());
        if (!capability.isPresent()) {
            return;
        }
        IItemHandler inventory = (IItemHandler)capability.orElse((Object)EmptyHandler.INSTANCE);
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            ItemStack stack = this.inventory.extractItem(slot, Integer.MAX_VALUE, true);
            if (stack.func_190926_b()) continue;
            ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)stack, (boolean)true);
            int amount = stack.func_190916_E() - remainder.func_190916_E();
            if (amount <= 0) continue;
            stack = this.inventory.extractItem(slot, amount, false);
            ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)stack, (boolean)false);
        }
    }

    private void cacheItemHandler() {
        if (!this.capability.isPresent()) {
            ItemIOMode mode;
            LazyOptional capability = this.getMultiCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
            if (!capability.isPresent()) {
                return;
            }
            this.capability = LazyOptional.of(() -> this);
            this.inventory = (IItemHandler)capability.orElse((Object)EmptyHandler.INSTANCE);
            if (this.inventory instanceof IMultiItemIOHandler) {
                this.ioHandler = (IMultiItemIOHandler)this.inventory;
            }
            if (!this.isSupported(mode = this.mode.get())) {
                this.nextMode(this.func_195044_w());
            } else if (this.ioHandler != null) {
                this.ioHandler.setActive(mode);
                this.inventory = this.ioHandler.access(mode);
            }
        } else {
            if (this.ioHandler != null) {
                this.ioHandler.setInactive(this.mode.get());
            }
            this.capability.invalidate();
            this.capability = LazyOptional.empty();
            this.inventory = EmptyHandler.INSTANCE;
            this.ioHandler = null;
        }
        this.updateNeighbourForOutputSignal();
    }

    @Override
    public void onMultiValidation(MultiBlock multiBlock) {
        super.onMultiValidation(multiBlock);
        this.cacheItemHandler();
    }

    @Override
    public void onMultiInvalidation(MultiBlock multiBlock) {
        super.onMultiInvalidation(multiBlock);
        this.cacheItemHandler();
    }

    @Override
    public int getAnalogOutputSignal(BlockState state, World level, BlockPos pos) {
        return this.inventory.getSlots() > 0 ? ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)this.inventory) : 0;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        if (this.inventory instanceof IItemHandlerModifiable) {
            ((IItemHandlerModifiable)this.inventory).setStackInSlot(slot, stack);
        }
    }

    public int getSlots() {
        return this.inventory.getSlots();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.inventory.getStackInSlot(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return this.mode.get().isOutput() ? stack : this.inventory.insertItem(slot, stack, simulate);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemIOMode mode = this.mode.get();
        return mode == ItemIOMode.ANY || mode.isOutput() ? this.inventory.extractItem(slot, amount, simulate) : ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        return this.inventory.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return this.inventory.isItemValid(slot, stack);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> type, @Nullable Direction side) {
        return !this.field_145846_f && this.capability.isPresent() && type == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.capability.cast() : super.getCapability(type, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.capability.invalidate();
    }
}

