/*
 * Decompiled with CFR 0.152.
 */
package nikita488.zycraft.multiblock;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import nikita488.zycraft.init.ZYLang;
import nikita488.zycraft.init.ZYMultiTypes;
import nikita488.zycraft.menu.TankContainer;
import nikita488.zycraft.multiblock.IDynamicMultiBlock;
import nikita488.zycraft.multiblock.MultiBlock;
import nikita488.zycraft.multiblock.fluid.MultiFluidTank;
import nikita488.zycraft.multiblock.inventory.MultiItemIOHandler;
import nikita488.zycraft.util.Cuboid6i;
import nikita488.zycraft.util.FluidUtils;
import nikita488.zycraft.util.InventoryUtils;

public class TankMultiBlock
extends MultiBlock
implements IDynamicMultiBlock,
INamedContainerProvider {
    public static final int INPUT_SLOT = 0;
    public static final int OUTPUT_SLOT = 1;
    private Cuboid6i innerArea;
    private final NonNullLazy<MultiFluidTank> tank = NonNullLazy.of(() -> new MultiFluidTank(this.innerArea){

        @Override
        public void onContentsChanged() {
            super.onContentsChanged();
            TankMultiBlock.this.markUnsaved();
            TankMultiBlock.this.updateInterfacesForOutputSignal();
        }

        @Override
        public void sendUpdated() {
            TankMultiBlock.this.sendMultiUpdated();
        }
    });
    private final MultiItemIOHandler inventory = new MultiItemIOHandler(2){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent();
        }

        protected void onContentsChanged(int slot) {
            TankMultiBlock.this.markUnsaved();
            TankMultiBlock.this.updateInterfacesForOutputSignal();
        }
    }.input(0).output(1);
    private LazyOptional<IFluidHandler> fluidCapability = LazyOptional.empty();
    private LazyOptional<IItemHandler> itemCapability = LazyOptional.empty();

    public TankMultiBlock(World level, ChunkPos pos) {
        super(ZYMultiTypes.TANK.get(), level, pos);
    }

    public TankMultiBlock(World level, Cuboid6i innerArea) {
        this(level, new ChunkPos(innerArea.center()));
        this.innerArea = innerArea.immutable();
        this.tank.get();
    }

    @Override
    public void initChildBlocks() {
        this.addChildBlocks(this.innerArea.minX() - 1, this.innerArea.minY() - 1, this.innerArea.minZ() - 1, this.innerArea.maxX() + 1, this.innerArea.maxY() + 1, this.innerArea.maxZ() + 1);
    }

    @Override
    public BlockPos origin() {
        return (BlockPos)this.childBlocks.get(0);
    }

    @Override
    public AxisAlignedBB aabb() {
        return new AxisAlignedBB((double)this.innerArea.minX(), (double)this.innerArea.minY(), (double)this.innerArea.minZ(), (double)(this.innerArea.maxX() + 1), (double)(this.innerArea.maxY() + 1), (double)(this.innerArea.maxZ() + 1));
    }

    public ITextComponent func_145748_c_() {
        return ZYLang.TANK;
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity player) {
        return new TankContainer(id, playerInventory, this);
    }

    @Override
    public ActionResultType onBlockActivated(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hitResult) {
        if (!level.func_201670_d()) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this, buffer -> buffer.func_150787_b(((MultiFluidTank)this.tank.get()).getCapacity()));
        }
        return ActionResultType.func_233537_a_((boolean)level.func_201670_d());
    }

    @Override
    public void tick() {
        if (this.level.func_201670_d()) {
            ((MultiFluidTank)this.tank.get()).tick();
            return;
        }
        Optional<IFluidHandlerItem> capability = FluidUtils.getItemFluidHandler(this.inventory.getStackInSlot(0));
        if (!capability.isPresent()) {
            return;
        }
        IFluidHandlerItem handler = capability.get();
        FluidStack containerFluid = handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
        if (!containerFluid.isEmpty()) {
            FluidStack drained;
            int filled = ((MultiFluidTank)this.tank.get()).fill(containerFluid, IFluidHandler.FluidAction.SIMULATE);
            FluidStack fluidStack = drained = filled > 0 ? handler.drain(filled, IFluidHandler.FluidAction.EXECUTE) : FluidStack.EMPTY;
            if (drained.isEmpty()) {
                return;
            }
            ItemStack container = handler.getContainer();
            if (!this.inventory.insertItem(1, container, true).func_190926_b()) {
                return;
            }
            this.inventory.extractItem(0, 1, false);
            this.inventory.insertItem(1, container, false);
            ((MultiFluidTank)this.tank.get()).fill(drained, IFluidHandler.FluidAction.EXECUTE);
        } else {
            FluidStack fluid = ((MultiFluidTank)this.tank.get()).getFluid();
            if (fluid.isEmpty()) {
                return;
            }
            int filled = handler.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
            ItemStack container = handler.getContainer();
            if (filled <= 0 || !this.inventory.insertItem(1, container, true).func_190926_b()) {
                return;
            }
            this.inventory.extractItem(0, 1, false);
            this.inventory.insertItem(1, container, false);
            ((MultiFluidTank)this.tank.get()).drain(filled, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    @Override
    public void render(MatrixStack stack, IRenderTypeBuffer source, int lightMap, float partialTicks) {
        ((MultiFluidTank)this.tank.get()).render(stack, source, (IBlockDisplayReader)this.level, partialTicks);
    }

    @Override
    public void validate(MultiBlock.AddingReason reason) {
        this.fluidCapability = LazyOptional.of(() -> this.tank.get());
        this.itemCapability = LazyOptional.of(() -> this.inventory);
        super.validate(reason);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        InventoryUtils.dropInventoryItems(this.level, this.innerArea.center(), (IItemHandler)this.inventory);
        this.updateInterfacesForOutputSignal();
    }

    @Override
    protected void invalidateCapabilities() {
        this.fluidCapability.invalidate();
        this.itemCapability.invalidate();
    }

    @Override
    public void load(CompoundNBT tag) {
        this.innerArea = Cuboid6i.load(tag.func_74775_l("InnerArea"));
        ((MultiFluidTank)this.tank.get()).readFromNBT(tag.func_74775_l("Tank"));
        this.inventory.deserializeNBT(tag.func_74775_l("Inventory"));
    }

    @Override
    public void save(CompoundNBT tag) {
        tag.func_218657_a("InnerArea", (INBT)this.innerArea.save(new CompoundNBT()));
        tag.func_218657_a("Tank", (INBT)((MultiFluidTank)this.tank.get()).writeToNBT(new CompoundNBT()));
        tag.func_218657_a("Inventory", (INBT)this.inventory.serializeNBT());
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.innerArea = Cuboid6i.decode(buffer);
        ((MultiFluidTank)this.tank.get()).decode(buffer);
    }

    @Override
    public void encode(PacketBuffer buffer) {
        this.innerArea.encode(buffer);
        ((MultiFluidTank)this.tank.get()).encode(buffer);
    }

    @Override
    public void decodeUpdate(PacketBuffer buffer) {
        ((MultiFluidTank)this.tank.get()).decodeUpdate(buffer);
    }

    @Override
    public void encodeUpdate(PacketBuffer buffer) {
        ((MultiFluidTank)this.tank.get()).encode(buffer);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> type, @Nullable BlockPos pos) {
        if (!this.valid) {
            return LazyOptional.empty();
        }
        if (type == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidCapability.cast();
        }
        if (type == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemCapability.cast();
        }
        return LazyOptional.empty();
    }

    public MultiFluidTank fluidTank() {
        return (MultiFluidTank)this.tank.get();
    }

    public MultiItemIOHandler inventory() {
        return this.inventory;
    }
}

