/*
 * Decompiled with CFR 0.152.
 */
package nikita488.zycraft.multiblock;

import com.google.common.base.MoreObjects;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import nikita488.zycraft.ZYCraft;
import nikita488.zycraft.multiblock.MultiManager;
import nikita488.zycraft.multiblock.MultiType;
import nikita488.zycraft.multiblock.child.IMultiChild;
import nikita488.zycraft.multiblock.child.tile.ValveTile;
import nikita488.zycraft.network.ZYPackets;
import nikita488.zycraft.util.Cuboid6i;

public abstract class MultiBlock {
    private static final AtomicInteger NEXT_MULTI_ID = new AtomicInteger();
    final MultiType<?> type;
    final MultiManager manager;
    final World level;
    final ChunkPos mainChunk;
    final ObjectList<BlockPos> childBlocks = new ObjectArrayList();
    final ObjectList<BlockPos> interfaces = new ObjectArrayList();
    final ObjectSet<ChunkPos> parentChunks = new ObjectOpenHashSet();
    private int id;
    boolean valid;
    private boolean changed;

    public MultiBlock(MultiType<?> type, World level, ChunkPos mainChunk) {
        this.type = type;
        this.manager = MultiManager.getInstance((IWorld)level);
        this.level = level;
        this.mainChunk = mainChunk;
        this.id = !level.func_201670_d() ? NEXT_MULTI_ID.incrementAndGet() : 0;
    }

    public final void form() {
        this.manager.addMultiBlock(this, AddingReason.FORMED);
    }

    public final void destroy() {
        this.manager.removeMultiBlock(this, RemovalReason.DESTROYED);
    }

    public final void addChildBlocks(Cuboid6i cuboid) {
        this.addChildBlocks(cuboid.minX(), cuboid.minY(), cuboid.minZ(), cuboid.maxX(), cuboid.maxY(), cuboid.maxZ());
    }

    public final void addChildBlocks(int x1, int y1, int z1, int x2, int y2, int z2) {
        for (int x = x1; x <= x2; ++x) {
            for (int y = y1; y <= y2; ++y) {
                for (int z = z1; z <= z2; ++z) {
                    this.addChildBlock(new BlockPos(x, y, z));
                }
            }
        }
    }

    public final void addChildBlock(BlockPos pos) {
        this.childBlocks.add((Object)pos.func_185334_h());
        this.parentChunks.add((Object)new ChunkPos(pos));
    }

    public final void addInterface(BlockPos pos) {
        this.interfaces.add((Object)pos.func_185334_h());
    }

    public void validate(AddingReason reason) {
        if (this.childBlocks.isEmpty()) {
            return;
        }
        this.valid = true;
        for (BlockPos pos : this.childBlocks) {
            TileEntity blockEntity;
            if (!this.level.func_195588_v(pos) || !((blockEntity = this.level.func_175625_s(pos)) instanceof IMultiChild)) continue;
            IMultiChild child = (IMultiChild)blockEntity;
            child.onMultiValidation(this);
            this.onChildValidation(child);
        }
    }

    public void onDestroy() {
        this.splitFluids();
    }

    protected void invalidateCapabilities() {
    }

    public void invalidate(RemovalReason reason) {
        if (!this.level.func_201670_d() && reason.isDestroyed()) {
            this.onDestroy();
        }
        this.valid = false;
        for (BlockPos pos : this.childBlocks) {
            TileEntity blockEntity;
            if (!this.level.func_195588_v(pos) || !((blockEntity = this.level.func_175625_s(pos)) instanceof IMultiChild)) continue;
            IMultiChild child = (IMultiChild)blockEntity;
            child.onMultiInvalidation(this);
            this.onChildInvalidation(child);
        }
        this.invalidateCapabilities();
    }

    public void onChildValidation(IMultiChild child) {
    }

    public void onChildInvalidation(IMultiChild child) {
    }

    public abstract void initChildBlocks();

    public ActionResultType onBlockActivated(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hitResult) {
        return ActionResultType.PASS;
    }

    public int getLightValue(BlockState state, IBlockReader getter, BlockPos pos) {
        return state.func_185906_d();
    }

    public final void sendMultiUpdated() {
        this.manager.sendMultiUpdated(this);
    }

    protected final void splitFluids() {
        Object2ObjectArrayMap tankValves = new Object2ObjectArrayMap();
        for (BlockPos pos : this.interfaces) {
            ValveTile valve;
            TileEntity blockEntity;
            if (!this.level.func_195588_v(pos)) continue;
            LazyOptional capability = this.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, pos);
            IFluidHandler tank2 = (IFluidHandler)capability.orElse((Object)EmptyFluidHandler.INSTANCE);
            if (!capability.isPresent() || tank2.getFluidInTank(0).isEmpty() || !((blockEntity = this.level.func_175625_s(pos)) instanceof ValveTile) || (valve = (ValveTile)blockEntity).hasStoredFluid()) continue;
            ((ObjectList)tankValves.computeIfAbsent((Object)tank2, key -> new ObjectArrayList())).add((Object)valve);
        }
        tankValves.forEach((tank, valves) -> {
            FluidStack fluid = tank.getFluidInTank(0).copy();
            fluid.setAmount(fluid.getAmount() / valves.size());
            for (ValveTile valve : valves) {
                valve.setStoredFluid(fluid);
            }
        });
    }

    public void encode(PacketBuffer buffer) {
    }

    public void decode(PacketBuffer buffer) {
    }

    public void encodeUpdate(PacketBuffer buffer) {
        this.encode(buffer);
    }

    public void decodeUpdate(PacketBuffer buffer) {
        this.decode(buffer);
    }

    public void save(CompoundNBT tag) {
    }

    public void load(CompoundNBT tag) {
    }

    public final void markUnsaved() {
        if (!this.level.func_201670_d() && this.level.func_217354_b(this.mainChunk.field_77276_a, this.mainChunk.field_77275_b)) {
            this.level.func_212866_a_(this.mainChunk.field_77276_a, this.mainChunk.field_77275_b).func_76630_e();
        }
    }

    public final void updateInterfacesForOutputSignal() {
        if (!this.level.func_201670_d()) {
            for (BlockPos pos : this.interfaces) {
                if (!this.level.func_195588_v(pos)) continue;
                this.level.func_175666_e(pos, this.level.func_180495_p(pos).func_177230_c());
            }
        }
    }

    public final boolean isMainChunk(ChunkPos chunkPos) {
        return chunkPos.equals((Object)this.mainChunk);
    }

    public final boolean isLoaded() {
        for (ChunkPos pos : this.parentChunks) {
            if (this.level.func_72863_F().func_73149_a(pos.field_77276_a, pos.field_77275_b)) continue;
            return false;
        }
        return true;
    }

    public final <MSG> void sendToTracking(MSG message) {
        ZYCraft.CHANNEL.send(ZYPackets.TRACKING_MULTI_BLOCK.with(() -> this), message);
    }

    public final boolean isClientSide() {
        return this.level.func_201670_d();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> type, @Nullable BlockPos pos) {
        return LazyOptional.empty();
    }

    public void fillCrashReportCategory(CrashReportCategory category) {
        category.func_189529_a("MultiBlock Type", () -> this.type.getRegistryName() + " (" + this.getClass().getCanonicalName() + ")");
        category.func_71507_a("MultiBlock Main Chunk", (Object)this.mainChunk);
        category.func_71507_a("MultiBlock ID", (Object)this.id);
    }

    public final MultiType<?> type() {
        return this.type;
    }

    public final World level() {
        return this.level;
    }

    public final ChunkPos mainChunk() {
        return this.mainChunk;
    }

    public final ObjectList<BlockPos> childBlocks() {
        return this.childBlocks;
    }

    public final ObjectSet<ChunkPos> parentChunks() {
        return this.parentChunks;
    }

    public final int id() {
        return this.id;
    }

    public final void setID(int id) {
        this.id = id;
    }

    public final boolean isValid() {
        return this.valid;
    }

    protected final boolean isChanged() {
        return this.changed;
    }

    protected final void setChanged(boolean changed) {
        this.changed = changed;
    }

    public final boolean equals(Object obj) {
        return obj == this || obj instanceof MultiBlock && this.id == ((MultiBlock)obj).id;
    }

    public final int hashCode() {
        return this.id;
    }

    public final String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type.getRegistryName()).add("level", (Object)(this.level.toString() + "/" + this.level.func_234923_W_().func_240901_a_())).add("mainChunk", (Object)this.mainChunk).add("id", this.id).toString();
    }

    public static enum RemovalReason {
        DESTROYED,
        UNLOADED;


        public boolean isDestroyed() {
            return this == DESTROYED;
        }

        public boolean isUnloaded() {
            return this == UNLOADED;
        }
    }

    public static enum AddingReason {
        FORMED,
        LOADED;


        public boolean isFormed() {
            return this == FORMED;
        }

        public boolean isLoaded() {
            return this == LOADED;
        }
    }
}

