/*
 * Decompiled with CFR 0.152.
 */
package nikita488.zycraft.menu.data;

import java.util.EnumSet;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import nikita488.zycraft.block.state.properties.ItemIOMode;
import nikita488.zycraft.menu.data.IMenuData;
import nikita488.zycraft.multiblock.inventory.IMultiItemIOHandler;

public class IOMenuData
implements IMenuData,
Supplier<EnumSet<ItemIOMode>> {
    private final EnumSet<ItemIOMode> activeModes = EnumSet.noneOf(ItemIOMode.class);
    @Nullable
    private Supplier<IMultiItemIOHandler> supplier;

    public IOMenuData() {
    }

    public IOMenuData(@Nullable Supplier<IMultiItemIOHandler> supplier) {
        this.supplier = supplier;
    }

    @Override
    public boolean canBeUpdated() {
        if (this.supplier != null) {
            for (ItemIOMode mode : ItemIOMode.VALUES) {
                if (this.activeModes.contains((Object)mode) == this.supplier.get().isActive(mode)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void update() {
        this.activeModes.clear();
        if (this.supplier != null) {
            for (ItemIOMode mode : ItemIOMode.VALUES) {
                if (!this.supplier.get().isActive(mode)) continue;
                this.activeModes.add(mode);
            }
        }
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_150787_b(this.activeModes.size());
        for (ItemIOMode mode : this.activeModes) {
            buffer.func_179249_a((Enum)mode);
        }
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.activeModes.clear();
        int activeCount = buffer.func_150792_a();
        for (int i = 0; i < activeCount; ++i) {
            this.activeModes.add((ItemIOMode)buffer.func_179257_a(ItemIOMode.class));
        }
    }

    @Override
    public EnumSet<ItemIOMode> get() {
        return this.activeModes;
    }
}

