/*
 * Decompiled with CFR 0.152.
 */
package nikita488.zycraft.menu.data;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fluids.FluidStack;
import nikita488.zycraft.menu.data.IMenuData;

public class FluidMenuData
implements IMenuData,
Supplier<FluidStack> {
    private FluidStack fluid = FluidStack.EMPTY;
    @Nullable
    private Supplier<FluidStack> supplier;

    public FluidMenuData() {
    }

    public FluidMenuData(@Nullable Supplier<FluidStack> supplier) {
        this.supplier = supplier;
    }

    @Override
    public boolean canBeUpdated() {
        return this.supplier != null && !this.fluid.isFluidStackIdentical(this.supplier.get());
    }

    @Override
    public void update() {
        if (this.supplier != null) {
            this.fluid = this.supplier.get().copy();
        }
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeFluidStack(this.fluid);
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.fluid = buffer.readFluidStack();
    }

    @Override
    public FluidStack get() {
        return this.fluid;
    }
}

