/*
 * Decompiled with CFR 0.152.
 */
package nikita488.zycraft.enums;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.util.Util;
import nikita488.zycraft.repack.registrate.util.nullness.NonNullBiFunction;

public enum ZYType {
    BLUE("blue", 25855, 6463, MaterialColor.field_151649_A),
    GREEN("green", 65280, 8192, MaterialColor.field_151651_C),
    RED("red", 0xFF0000, 0x200000, MaterialColor.field_151645_D),
    DARK("dark", 0x1E1E1E, 0x1E1E1E, MaterialColor.field_151646_E),
    LIGHT("light", 0xFFFFFF, 0xFFFFFF, MaterialColor.field_151677_p);

    private final String name;
    private final int color;
    private final int overlayColor;
    private final MaterialColor mtlColor;
    public static final ZYType[] VALUES;

    private ZYType(String name, int color, int overlayColor, MaterialColor mtlColor) {
        this.name = name;
        this.color = color;
        this.overlayColor = overlayColor;
        this.mtlColor = mtlColor;
    }

    public static ZYType randomType(Random random) {
        return (ZYType)((Object)Util.func_240989_a_((Object[])VALUES, (Random)random));
    }

    public static <T> Map<ZYType, T> buildMap(String pattern, NonNullBiFunction<ZYType, String, T> factory) {
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (ZYType type : VALUES) {
            map.put((Object)type, factory.apply(type, pattern.replace("{type}", type.toString())));
        }
        return map.build();
    }

    public int rgb() {
        return this.color;
    }

    public int overlayRGB() {
        return this.overlayColor;
    }

    public MaterialColor mtlColor() {
        return this.mtlColor;
    }

    public String toString() {
        return this.name;
    }

    static {
        VALUES = ZYType.values();
    }
}

