/*
 * Decompiled with CFR 0.152.
 */
package nikita488.zycraft.dispenser;

import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.DispenserTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import nikita488.zycraft.util.FluidUtils;

public class ZYBucketDispenseItemBehavior
extends DefaultDispenseItemBehavior {
    public static final ZYBucketDispenseItemBehavior INSTANCE = new ZYBucketDispenseItemBehavior();
    private final DefaultDispenseItemBehavior defaultBehaviour = new DefaultDispenseItemBehavior();

    public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
        Optional<IFluidHandlerItem> capability = FluidUtils.getItemFluidHandler(stack);
        if (!capability.isPresent()) {
            return stack;
        }
        IFluidHandlerItem handler = capability.get();
        FluidStack containedFluid = handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
        ServerWorld level = source.func_197524_h();
        BlockPos pos = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a));
        if (!containedFluid.isEmpty()) {
            if (FluidUtils.tryPlaceFluid(containedFluid, null, (World)level, pos, null)) {
                return new ItemStack((IItemProvider)stack.func_77973_b());
            }
            return this.defaultBehaviour.dispense(source, stack);
        }
        BlockState state = level.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof IBucketPickupHandler) {
            Fluid fluid = ((IBucketPickupHandler)block).func_204508_a((IWorld)level, pos, state);
            if (!(fluid instanceof FlowingFluid)) {
                return super.func_82487_b(source, stack);
            }
            FluidStack fluidStack = new FluidStack(fluid, 1000);
            if (handler.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE) != fluidStack.getAmount()) {
                return super.func_82487_b(source, stack);
            }
            handler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            stack.func_190918_g(1);
            ItemStack filledContainer = handler.getContainer();
            if (stack.func_190926_b()) {
                return filledContainer;
            }
            if (((DispenserTileEntity)source.func_150835_j()).func_146019_a(filledContainer) < 0) {
                this.defaultBehaviour.dispense(source, filledContainer);
            }
            return stack;
        }
        return super.func_82487_b(source, stack);
    }
}

