/*
 * Decompiled with CFR 0.152.
 */
package nikita488.zycraft.client;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Util;
import net.minecraftforge.fluids.FluidUtil;
import nikita488.zycraft.block.state.properties.ItemIOMode;
import nikita488.zycraft.block.state.properties.ValveIOMode;
import nikita488.zycraft.enums.ZYType;
import nikita488.zycraft.util.ItemStackUtils;

public enum ZYItemColors implements Supplier<IItemColor>
{
    ZYCHORIUM_LAMP((stack, tintIndex) -> 0x3F3F3F),
    FABRICATOR((stack, tintIndex) -> ZYType.BLUE.rgb()),
    VALVE((stack, tintIndex) -> tintIndex == 1 ? ValveIOMode.IN.rgb() : ZYType.BLUE.rgb()),
    ITEM_IO((stack, tintIndex) -> tintIndex == 1 ? ItemIOMode.ANY.rgb() : ZYType.GREEN.rgb()),
    COLOR_SCANNER((stack, tintIndex) -> ItemStackUtils.getInt(stack, "Color", 0xFFFFFF)),
    ALUMINIUM_FOIL((stack, tintIndex) -> tintIndex == 1 ? FluidUtil.getFluidContained((ItemStack)stack).map(containedFluid -> containedFluid.getFluid().getAttributes().getColor(containedFluid)).orElse(0xFFFFFF).intValue() : ZYType.GREEN.rgb());

    public static final Map<ZYType, IItemColor> ZY_COLORS;
    public static final Map<ZYType, IItemColor> ZY_COLORS_WITH_OVERLAY;
    private final IItemColor color;

    private ZYItemColors(IItemColor color) {
        this.color = color;
    }

    public static IItemColor getZYItemColor(ZYType type) {
        return ZYItemColors.getZYItemColor(type, false);
    }

    public static IItemColor getZYItemColor(ZYType type, boolean coloredOverlay) {
        return (coloredOverlay ? ZY_COLORS_WITH_OVERLAY : ZY_COLORS).get((Object)type);
    }

    @Override
    public IItemColor get() {
        return this.color;
    }

    static {
        ZY_COLORS = (Map)Util.func_199748_a(() -> {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (ZYType type : ZYType.VALUES) {
                builder.put((Object)type, (stack, tintIndex) -> type.rgb());
            }
            return builder.build();
        });
        ZY_COLORS_WITH_OVERLAY = (Map)Util.func_199748_a(() -> {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (ZYType type : ZYType.VALUES) {
                builder.put((Object)type, (stack, tintIndex) -> tintIndex == 1 ? type.overlayRGB() : type.rgb());
            }
            return builder.build();
        });
    }
}

