/*
 * Decompiled with CFR 0.152.
 */
package nikita488.zycraft.client;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import nikita488.zycraft.api.colorable.IColorable;
import nikita488.zycraft.block.state.properties.ItemIOMode;
import nikita488.zycraft.block.state.properties.ValveIOMode;
import nikita488.zycraft.enums.ZYType;
import nikita488.zycraft.multiblock.child.block.ItemIOBlock;
import nikita488.zycraft.multiblock.child.block.ValveBlock;
import nikita488.zycraft.multiblock.child.tile.ConvertedMultiChildTile;
import nikita488.zycraft.tile.FabricatorTile;
import nikita488.zycraft.tile.FluidSelectorTile;

public enum ZYBlockColors implements Supplier<IBlockColor>
{
    COLORABLE((state, getter, pos, tintIndex) -> {
        TileEntity blockEntity = ZYBlockColors.getBlockEntity(state, getter, pos);
        return blockEntity instanceof IColorable ? ((IColorable)blockEntity).getColor(state, getter, pos, tintIndex) : 0xFFFFFF;
    }),
    FABRICATOR((state, getter, pos, tintIndex) -> {
        TileEntity blockEntity = ZYBlockColors.getBlockEntity(state, getter, pos);
        return blockEntity instanceof FabricatorTile ? ((FabricatorTile)blockEntity).getColor(state) : ZYType.BLUE.rgb();
    }),
    CONVERTED_MULTI_CHILD((state, getter, pos, tintIndex) -> {
        TileEntity blockEntity = ZYBlockColors.getBlockEntity(state, getter, pos);
        return blockEntity instanceof ConvertedMultiChildTile ? Minecraft.func_71410_x().func_184125_al().func_228054_a_(((ConvertedMultiChildTile)blockEntity).initialState(), getter, pos, tintIndex) : 0xFFFFFF;
    }),
    VALVE((state, getter, pos, tintIndex) -> tintIndex == 1 ? ((ValveIOMode)((Object)((Object)state.func_177229_b(ValveBlock.IO_MODE)))).rgb() : ZYType.BLUE.rgb()),
    ITEM_IO((state, getter, pos, tintIndex) -> tintIndex == 1 ? ((ItemIOMode)((Object)((Object)state.func_177229_b(ItemIOBlock.IO_MODE)))).rgb() : ZYType.GREEN.rgb()),
    FLUID_SELECTOR((state, getter, pos, tintIndex) -> {
        TileEntity blockEntity = ZYBlockColors.getBlockEntity(state, getter, pos);
        return blockEntity instanceof FluidSelectorTile ? ((FluidSelectorTile)blockEntity).getColor() : 0xFFFFFF;
    });

    public static final Map<ZYType, IBlockColor> ZY_COLORS;
    public static final Map<ZYType, IBlockColor> ZY_COLORS_WITH_OVERLAY;
    private final IBlockColor color;

    private ZYBlockColors(IBlockColor color) {
        this.color = color;
    }

    public static IBlockColor getZYBlockColor(ZYType type) {
        return ZYBlockColors.getZYBlockColor(type, false);
    }

    public static IBlockColor getZYBlockColor(ZYType type, boolean coloredOverlay) {
        return (coloredOverlay ? ZY_COLORS_WITH_OVERLAY : ZY_COLORS).get((Object)type);
    }

    @Nullable
    private static TileEntity getBlockEntity(BlockState state, @Nullable IBlockDisplayReader getter, @Nullable BlockPos pos) {
        return getter != null && pos != null && state.hasTileEntity() ? getter.func_175625_s(pos) : null;
    }

    @Override
    public IBlockColor get() {
        return this.color;
    }

    static {
        ZY_COLORS = (Map)Util.func_199748_a(() -> {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (ZYType type : ZYType.VALUES) {
                builder.put((Object)type, (state, getter, pos, tintIndex) -> type.rgb());
            }
            return builder.build();
        });
        ZY_COLORS_WITH_OVERLAY = (Map)Util.func_199748_a(() -> {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (ZYType type : ZYType.VALUES) {
                builder.put((Object)type, (state, getter, pos, tintIndex) -> tintIndex == 1 ? type.overlayRGB() : type.rgb());
            }
            return builder.build();
        });
    }
}

