/*
 * Decompiled with CFR 0.152.
 */
package nikita488.zycraft.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import nikita488.zycraft.api.fluid.IFluidSource;
import nikita488.zycraft.init.ZYLang;
import nikita488.zycraft.init.ZYTiles;
import nikita488.zycraft.tile.FluidSelectorTile;

public class FluidSelectorBlock
extends Block
implements IFluidSource {
    public FluidSelectorBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader getter) {
        return ZYTiles.FLUID_SELECTOR.create();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader getter, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add((ITextComponent)ZYLang.CREATIVE_ONLY);
    }

    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hitResult) {
        FluidStack containedFluid = FluidUtil.getFluidContained((ItemStack)player.func_184586_b(hand)).orElse(FluidStack.EMPTY);
        if (containedFluid.isEmpty()) {
            return ActionResultType.PASS;
        }
        FluidSelectorTile selector = ZYTiles.FLUID_SELECTOR.getNullable((IBlockReader)level, pos);
        if (selector != null) {
            if (!selector.canSelectFluid(containedFluid)) {
                return ActionResultType.CONSUME;
            }
            if (!level.func_201670_d()) {
                selector.setSelectedFluid(containedFluid);
            }
        }
        return ActionResultType.func_233537_a_((boolean)level.func_201670_d());
    }

    @Override
    public FluidStack getFluid(BlockState state, World level, BlockPos pos, @Nullable Direction side) {
        FluidSelectorTile fluidSelector = ZYTiles.FLUID_SELECTOR.getNullable((IBlockReader)level, pos);
        return fluidSelector != null ? fluidSelector.getSelectedFluid() : FluidStack.EMPTY;
    }
}

