/*
 * Decompiled with CFR 0.152.
 */
package nikita488.zycraft.block;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import nikita488.zycraft.block.state.properties.FabricatorMode;
import nikita488.zycraft.block.state.properties.ZYBlockStateProperties;
import nikita488.zycraft.init.ZYTiles;
import nikita488.zycraft.tile.FabricatorTile;

public class FabricatorBlock
extends Block {
    public static final EnumProperty<FabricatorMode> MODE = ZYBlockStateProperties.FABRICATOR_MODE;

    public FabricatorBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a(MODE, (Comparable)((Object)FabricatorMode.AUTO_LOW)));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader getter) {
        return ZYTiles.FABRICATOR.create();
    }

    public void onNeighborChange(BlockState state, IWorldReader reader, BlockPos pos, BlockPos relativePos) {
        if (reader.func_201670_d()) {
            return;
        }
        Direction side = Direction.func_176737_a((float)(relativePos.func_177958_n() - pos.func_177958_n()), (float)(relativePos.func_177956_o() - pos.func_177956_o()), (float)(relativePos.func_177952_p() - pos.func_177952_p()));
        if (side != Direction.UP) {
            ZYTiles.FABRICATOR.get((IBlockReader)reader, pos).ifPresent(fabricator -> fabricator.logic().setSideChanged(side));
        }
    }

    public void func_196243_a(BlockState state, World level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (level.func_201670_d() || state.func_203425_a(newState.func_177230_c())) {
            return;
        }
        FabricatorTile fabricator = ZYTiles.FABRICATOR.getNullable((IBlockReader)level, pos);
        if (fabricator != null) {
            fabricator.dropItems();
            level.func_175666_e(pos, (Block)this);
        }
        super.func_196243_a(state, level, pos, newState, isMoving);
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World level, BlockPos pos) {
        return ZYTiles.FABRICATOR.get((IBlockReader)level, pos).map(FabricatorTile::getAnalogOutputSignal).orElse(0);
    }

    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hitResult) {
        if (!level.func_201670_d()) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)ZYTiles.FABRICATOR.getNullable((IBlockReader)level, pos));
        }
        return ActionResultType.func_233537_a_((boolean)level.func_201670_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{MODE});
    }
}

