/*
 * Decompiled with CFR 0.152.
 */
package nikita488.zycraft.tile;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.fluids.FluidStack;
import nikita488.zycraft.tile.ZYTile;
import nikita488.zycraft.util.Color;

public class FluidSelectorTile
extends ZYTile {
    @Nullable
    private float[] hsv;
    private FluidStack selectedFluid = FluidStack.EMPTY;

    public FluidSelectorTile(TileEntityType<?> type) {
        super(type);
    }

    public int getColor() {
        float brightness = (float)(15 - this.field_145850_b.func_175687_A(this.field_174879_c)) / 15.0f;
        return this.hsv != null ? Color.hsvToRGB(this.hsv[0], this.hsv[1], this.hsv[2] * brightness) : 0xFFFFFF;
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        if (tag.func_150297_b("SelectedFluid", 10)) {
            this.selectedFluid = FluidStack.loadFluidStackFromNBT((CompoundNBT)tag.func_74775_l("SelectedFluid"));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        if (!this.selectedFluid.isEmpty()) {
            tag.func_218657_a("SelectedFluid", (INBT)this.selectedFluid.writeToNBT(new CompoundNBT()));
        }
        return tag;
    }

    @Override
    public void decode(CompoundNBT tag) {
        this.selectedFluid = FluidStack.loadFluidStackFromNBT((CompoundNBT)tag);
        if (this.selectedFluid.isEmpty()) {
            return;
        }
        int color = this.selectedFluid.getFluid().getAttributes().getColor(this.selectedFluid);
        this.hsv = Color.rgbToHSV(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF);
    }

    @Override
    public void decodeUpdate(CompoundNBT tag) {
        super.decodeUpdate(tag);
        this.blockChanged();
    }

    @Override
    public void encode(CompoundNBT tag) {
        if (!this.selectedFluid.isEmpty()) {
            this.selectedFluid.writeToNBT(tag);
        }
    }

    public boolean canSelectFluid(FluidStack stack) {
        return !stack.isFluidEqual(this.selectedFluid);
    }

    public FluidStack getSelectedFluid() {
        if (this.selectedFluid.isEmpty()) {
            return FluidStack.EMPTY;
        }
        FluidStack stack = this.selectedFluid.copy();
        stack.setAmount(150 - this.field_145850_b.func_175687_A(this.field_174879_c) * 10);
        return stack;
    }

    public void setSelectedFluid(FluidStack stack) {
        if (this.selectedFluid.isFluidEqual(stack)) {
            return;
        }
        this.selectedFluid = stack;
        this.selectedFluid.setAmount(150);
        this.func_70296_d();
        this.sendUpdated();
    }
}

