/*
 * Decompiled with CFR 0.152.
 */
package nikita488.zycraft.tile;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.EnumMap;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.hooks.BasicEventHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;
import nikita488.zycraft.menu.ZYContainer;
import nikita488.zycraft.tile.FabricatorTile;
import nikita488.zycraft.util.ItemStackUtils;
import nikita488.zycraft.util.ZYConstants;

public class FabricatorLogic {
    private final FabricatorTile fabricator;
    private final EnumSet<Direction> checkedSides = EnumSet.noneOf(Direction.class);
    private final EnumSet<Direction> pendingSides = EnumSet.noneOf(Direction.class);
    private final EnumMap<Direction, ObjectList<ItemStack>> pendingItems = new EnumMap(Direction.class);
    private final CraftingInventory craftingInventory = new CraftingInventory(ZYContainer.EMPTY_CONTAINER, 3, 3);
    private int foundIngredientCount;

    public FabricatorLogic(FabricatorTile fabricator) {
        this.fabricator = fabricator;
    }

    private LazyOptional<IItemHandler> getRelativeInventory(Direction side) {
        BlockPos relativePos;
        World level = this.fabricator.func_145831_w();
        if (!level.func_195588_v(relativePos = this.fabricator.func_174877_v().func_177972_a(side))) {
            return LazyOptional.empty();
        }
        TileEntity blockEntity = level.func_175625_s(relativePos);
        return blockEntity != null ? blockEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.func_176734_d()) : LazyOptional.empty();
    }

    private ItemStack insertItem(IItemHandler inventory, ItemStack stack) {
        return ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)stack, (boolean)false);
    }

    public boolean updatePendingItems() {
        if (this.pendingItems.isEmpty()) {
            return false;
        }
        for (Direction side : ZYConstants.DIRECTIONS) {
            ObjectList<ItemStack> items;
            if (this.isSideChecked(side) || (items = this.pendingItems.get(side)) == null) continue;
            this.setSideChecked(side);
            ItemStackHandler inventory = this.fabricator.inventory();
            if (side != Direction.UP) {
                LazyOptional<IItemHandler> capability = this.getRelativeInventory(side);
                if (!capability.isPresent()) continue;
                inventory = (IItemHandler)capability.orElse((Object)EmptyHandler.INSTANCE);
            }
            ObjectListIterator iterator = items.iterator();
            while (iterator.hasNext()) {
                ItemStack remainder = this.insertItem((IItemHandler)inventory, (ItemStack)iterator.next());
                if (remainder.func_190926_b()) {
                    iterator.remove();
                    continue;
                }
                iterator.set((Object)remainder);
            }
            if (items.isEmpty()) {
                this.pendingItems.remove(side);
                this.fabricator.func_70296_d();
            }
            if (!this.pendingItems.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private void tryInsertItem(IItemHandler inventory, ItemStack stack) {
        this.tryInsertItem(Direction.UP, inventory, stack);
    }

    private void tryInsertItem(RecipeIngredient ingredient, ItemStack stack) {
        this.tryInsertItem(ingredient.side(), ingredient.inventory(), stack);
    }

    private void tryInsertItem(Direction side, IItemHandler inventory, ItemStack stack) {
        ItemStack remainder = this.insertItem(inventory, stack);
        if (remainder.func_190926_b()) {
            return;
        }
        this.addPendingItem(side, remainder);
        this.fabricator.func_70296_d();
        this.checkedSides.removeAll(this.pendingSides);
    }

    public void tryCraft() {
        int slot;
        ICraftingRecipe recipe = this.fabricator.craftingRecipe();
        ItemStack craftingResult = this.fabricator.craftingResultStack();
        if (recipe == null || craftingResult.func_190926_b() || this.isAllSidesChecked()) {
            return;
        }
        RecipeIngredient[] ingredients = this.getIngredients((NonNullList<Ingredient>)recipe.func_192400_c());
        if (ingredients == null) {
            return;
        }
        for (int slot2 = 0; slot2 < ingredients.length; ++slot2) {
            this.craftingInventory.func_70299_a(slot2, ingredients[slot2].stack());
        }
        FakePlayer player = this.fabricator.player();
        BlockPos pos = this.fabricator.func_174877_v();
        player.func_226288_n_((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
        craftingResult.func_77980_a(this.fabricator.func_145831_w(), (PlayerEntity)player, craftingResult.func_190916_E());
        BasicEventHooks.firePlayerCraftingEvent((PlayerEntity)player, (ItemStack)craftingResult, (IInventory)this.craftingInventory);
        ForgeHooks.setCraftingPlayer((PlayerEntity)player);
        NonNullList remainingItems = recipe.func_179532_b((IInventory)this.craftingInventory);
        ForgeHooks.setCraftingPlayer(null);
        for (RecipeIngredient ingredient : ingredients) {
            ingredient.extract();
        }
        this.tryInsertItem((IItemHandler)this.fabricator.inventory(), craftingResult);
        PlayerInventory playerInventory = player.field_71071_by;
        for (slot = 0; slot < playerInventory.func_70302_i_(); ++slot) {
            ItemStack stack = playerInventory.func_70301_a(slot);
            if (stack.func_190926_b()) continue;
            this.tryInsertItem((IItemHandler)this.fabricator.inventory(), stack);
        }
        for (slot = 0; slot < ingredients.length; ++slot) {
            ItemStack stack = (ItemStack)remainingItems.get(slot);
            if (stack.func_190926_b()) continue;
            this.tryInsertItem(ingredients[slot], stack);
        }
        this.pendingSides.clear();
        playerInventory.func_174888_l();
        this.craftingInventory.func_174888_l();
    }

    @Nullable
    private RecipeIngredient[] getIngredients(NonNullList<Ingredient> recipeIngredients) {
        RecipeIngredient[] foundIngredients = new RecipeIngredient[recipeIngredients.size()];
        this.foundIngredientCount = 0;
        for (int i = 0; i < foundIngredients.length; ++i) {
            if (recipeIngredients.get(i) != Ingredient.field_193370_a) continue;
            foundIngredients[i] = RecipeIngredient.EMPTY;
            ++this.foundIngredientCount;
        }
        if (!this.isSideChecked(Direction.UP)) {
            this.setSideChecked(Direction.UP);
            if (this.tryFindIngredients((IItemHandler)this.fabricator.inventory(), recipeIngredients, Direction.UP, foundIngredients)) {
                return foundIngredients;
            }
        }
        for (Direction side : ZYConstants.DIRECTIONS) {
            if (side == Direction.UP || this.isSideChecked(side)) continue;
            this.setSideChecked(side);
            LazyOptional<IItemHandler> capability = this.getRelativeInventory(side);
            if (!capability.isPresent() || !this.tryFindIngredients((IItemHandler)capability.orElse((Object)EmptyHandler.INSTANCE), recipeIngredients, side, foundIngredients)) continue;
            return foundIngredients;
        }
        return null;
    }

    private boolean tryFindIngredients(IItemHandler inventory, NonNullList<Ingredient> recipeIngredients, Direction side, RecipeIngredient[] foundIngredients) {
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            ItemStack stack = inventory.extractItem(slot, Integer.MAX_VALUE, true);
            if (stack.func_190926_b()) continue;
            for (int i = 0; i < foundIngredients.length; ++i) {
                if (foundIngredients[i] != null || !((Ingredient)recipeIngredients.get(i)).test(stack)) continue;
                foundIngredients[i] = new RecipeIngredient(side, inventory, slot);
                ++this.foundIngredientCount;
                this.pendingSides.add(side);
                stack.func_190918_g(1);
                if (stack.func_190926_b()) break;
            }
            if (this.foundIngredientCount != recipeIngredients.size()) continue;
            return true;
        }
        return false;
    }

    public void dropPendingItems() {
        BlockPos pos = this.fabricator.func_174877_v();
        for (ObjectList<ItemStack> items : this.pendingItems.values()) {
            items.forEach(stack -> InventoryHelper.func_180173_a((World)this.fabricator.func_145831_w(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack));
        }
    }

    public void load(CompoundNBT tag) {
        if (!tag.func_150297_b("PendingItems", 9)) {
            return;
        }
        ListNBT pendingItemTags = tag.func_150295_c("PendingItems", 10);
        for (int i = 0; i < pendingItemTags.size(); ++i) {
            CompoundNBT pendingItemTag = pendingItemTags.func_150305_b(i);
            Direction side = ZYConstants.DIRECTIONS[pendingItemTag.func_74762_e("Side")];
            this.addPendingItem(side, ItemStack.func_199557_a((CompoundNBT)pendingItemTag));
        }
    }

    public void save(CompoundNBT tag) {
        ListNBT pendingItemTags = new ListNBT();
        this.pendingItems.forEach((side, items) -> {
            for (ItemStack stack : items) {
                CompoundNBT pendingItemTag = new CompoundNBT();
                pendingItemTag.func_74768_a("Side", side.func_176745_a());
                stack.func_77955_b(pendingItemTag);
                pendingItemTags.add((Object)pendingItemTag);
            }
        });
        if (!pendingItemTags.isEmpty()) {
            tag.func_218657_a("PendingItems", (INBT)pendingItemTags);
        }
    }

    private void setSideChecked(Direction side) {
        this.checkedSides.add(side);
    }

    public void setSideChanged(Direction side) {
        this.checkedSides.remove(side);
        this.checkedSides.removeAll(this.pendingSides);
        this.pendingSides.clear();
    }

    private boolean isSideChecked(Direction side) {
        return this.checkedSides.contains(side);
    }

    private boolean isAllSidesChecked() {
        return this.checkedSides.size() == ZYConstants.DIRECTIONS.length;
    }

    public void recheckSides() {
        this.checkedSides.clear();
        this.pendingSides.clear();
    }

    private void addPendingItem(Direction side, ItemStack stack) {
        this.pendingItems.computeIfAbsent(side, key -> new ObjectArrayList()).add((Object)stack);
    }

    private static class RecipeIngredient {
        private static final RecipeIngredient EMPTY = new RecipeIngredient(Direction.UP, EmptyHandler.INSTANCE, -1);
        private final Direction side;
        private final IItemHandler inventory;
        private final int slot;

        public RecipeIngredient(Direction side, IItemHandler inventory, int slot) {
            this.side = side;
            this.inventory = inventory;
            this.slot = slot;
        }

        private boolean isEmpty() {
            return this == EMPTY || this.inventory.getSlots() <= 0 || this.slot < 0;
        }

        private ItemStack extract() {
            return this.inventory.extractItem(this.slot, 1, false);
        }

        private ItemStack stack() {
            return ItemStackUtils.copy(this.inventory.getStackInSlot(this.slot), 1);
        }

        private Direction side() {
            return this.side;
        }

        private IItemHandler inventory() {
            return this.inventory;
        }
    }
}

