/*
 * Decompiled with CFR 0.152.
 */
package nikita488.zycraft.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import nikita488.zycraft.init.ZYParticles;

public class SparkleParticleData
implements IParticleData {
    public static final Codec<SparkleParticleData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("color").forGetter(data -> data.color), (App)Codec.INT.fieldOf("lifetime_factor").forGetter(data -> data.lifetimeFactor), (App)Codec.FLOAT.fieldOf("size_factor").forGetter(data -> Float.valueOf(data.sizeFactor)), (App)Codec.FLOAT.fieldOf("gravity").forGetter(data -> Float.valueOf(data.gravity)), (App)Codec.BOOL.fieldOf("has_physics").forGetter(data -> data.hasPhysics), (App)Codec.BOOL.fieldOf("has_motion").forGetter(data -> data.hasMotion), (App)Codec.BOOL.fieldOf("has_fixed_size").forGetter(data -> data.hasFixedSize)).apply((Applicative)instance, SparkleParticleData::new));
    public static final IParticleData.IDeserializer<SparkleParticleData> DESERIALIZER = new IParticleData.IDeserializer<SparkleParticleData>(){

        public SparkleParticleData fromCommand(ParticleType<SparkleParticleData> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            int color = reader.readInt();
            reader.expect(' ');
            int lifetimeFactor = reader.readInt();
            reader.expect(' ');
            float sizeFactor = reader.readFloat();
            reader.expect(' ');
            float gravity = reader.readFloat();
            reader.expect(' ');
            boolean hasPhysics = reader.readBoolean();
            reader.expect(' ');
            boolean hasMotion = reader.readBoolean();
            reader.expect(' ');
            boolean hasFixedSize = reader.readBoolean();
            return new SparkleParticleData(color, lifetimeFactor, sizeFactor, gravity, hasPhysics, hasMotion, hasFixedSize);
        }

        public SparkleParticleData fromNetwork(ParticleType<SparkleParticleData> type, PacketBuffer buffer) {
            return new SparkleParticleData(buffer.func_150792_a(), buffer.func_150792_a(), buffer.readFloat(), buffer.readFloat(), buffer.readBoolean(), buffer.readBoolean(), buffer.readBoolean());
        }
    };
    private final int color;
    private final int lifetimeFactor;
    private final float sizeFactor;
    private final float gravity;
    private final boolean hasPhysics;
    private final boolean hasMotion;
    private final boolean hasFixedSize;

    public SparkleParticleData(int rgba, int lifetimeFactor, float sizeFactor, float gravity, boolean hasPhysics, boolean hasMotion, boolean hasFixedSize) {
        this.color = rgba;
        this.lifetimeFactor = lifetimeFactor;
        this.sizeFactor = sizeFactor;
        this.gravity = gravity;
        this.hasPhysics = hasPhysics;
        this.hasMotion = hasMotion;
        this.hasFixedSize = hasFixedSize;
    }

    public ParticleType<SparkleParticleData> func_197554_b() {
        return ZYParticles.SPARKLE.get();
    }

    public void func_197553_a(PacketBuffer buffer) {
        buffer.func_150787_b(this.color);
        buffer.func_150787_b(this.lifetimeFactor);
        buffer.writeFloat(this.sizeFactor);
        buffer.writeFloat(this.gravity);
        buffer.writeBoolean(this.hasPhysics);
        buffer.writeBoolean(this.hasMotion);
        buffer.writeBoolean(this.hasFixedSize);
    }

    public String func_197555_a() {
        return this.func_197554_b().getRegistryName().toString();
    }

    public float r() {
        return (float)(this.color >> 24 & 0xFF) / 255.0f;
    }

    public float g() {
        return (float)(this.color >> 16 & 0xFF) / 255.0f;
    }

    public float b() {
        return (float)(this.color >> 8 & 0xFF) / 255.0f;
    }

    public float a() {
        return (float)(this.color & 0xFF) / 255.0f;
    }

    public int lifetimeFactor() {
        return this.lifetimeFactor;
    }

    public float sizeFactor() {
        return this.sizeFactor;
    }

    public float gravity() {
        return this.gravity;
    }

    public boolean hasPhysics() {
        return this.hasPhysics;
    }

    public boolean hasMotion() {
        return this.hasMotion;
    }

    public boolean hasFixedSize() {
        return this.hasFixedSize;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int color = -65;
        private int lifetimeFactor = 1;
        private float sizeFactor = 1.0f;
        private float gravity;
        private boolean hasPhysics;
        private boolean hasMotion;
        private boolean hasFixedSize;

        public Builder color(int rgba) {
            this.color = rgba;
            return this;
        }

        public Builder lifetimeFactor(int factor) {
            this.lifetimeFactor = factor;
            return this;
        }

        public Builder sizeFactor(float factor) {
            this.sizeFactor = factor;
            return this;
        }

        public Builder gravity(float gravity) {
            this.gravity = gravity;
            return this;
        }

        public Builder hasPhysics() {
            this.hasPhysics = true;
            return this;
        }

        public Builder hasMotion() {
            this.hasMotion = true;
            return this;
        }

        public Builder hasFixedSize() {
            this.hasFixedSize = true;
            return this;
        }

        public SparkleParticleData build() {
            return new SparkleParticleData(this.color, this.lifetimeFactor, this.sizeFactor, this.gravity, this.hasPhysics, this.hasMotion, this.hasFixedSize);
        }
    }
}

