/*
 * Decompiled with CFR 0.152.
 */
package nikita488.zycraft.multiblock.child.tile;

import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import nikita488.zycraft.api.fluid.IFluidSource;
import nikita488.zycraft.api.fluid.IFluidVoid;
import nikita488.zycraft.block.state.properties.ValveIOMode;
import nikita488.zycraft.multiblock.MultiBlock;
import nikita488.zycraft.multiblock.child.block.ValveBlock;
import nikita488.zycraft.multiblock.child.tile.MultiInterfaceTile;
import nikita488.zycraft.multiblock.fluid.IMultiFluidHandler;
import nikita488.zycraft.util.FluidUtils;

public class ValveTile
extends MultiInterfaceTile
implements ITickableTileEntity,
IFluidHandler {
    private final Supplier<ValveIOMode> mode = () -> (ValveIOMode)((Object)((Object)this.func_195044_w().func_177229_b(ValveBlock.IO_MODE)));
    private LazyOptional<IFluidHandler> capability = LazyOptional.empty();
    private IFluidHandler mainTank = EmptyFluidHandler.INSTANCE;
    @Nullable
    private IMultiFluidHandler.Level fromTank;
    @Nullable
    private IMultiFluidHandler.Level toTank;
    private FluidStack storedFluid = FluidStack.EMPTY;

    public ValveTile(TileEntityType<?> type) {
        super(type);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.func_201670_d()) {
            if (this.capability.isPresent()) {
                this.update();
            } else if (this.parentCount() > 1) {
                this.balanceTanks();
            }
        }
    }

    @Override
    protected void processRelativePos(BlockPos pos, Direction side) {
        BlockState state = this.field_145850_b.func_180495_p(pos);
        if (this.mode.get().isOutput()) {
            this.eject(state, pos, side);
        } else {
            this.absorb(state, pos, side);
        }
    }

    private void eject(BlockState state, BlockPos pos, Direction side) {
        TileEntity blockEntity;
        if (state.func_177230_c() instanceof IFluidVoid) {
            int drainAmount;
            IFluidVoid fluidVoid = (IFluidVoid)state.func_177230_c();
            FluidStack fluidToDrain = fluidVoid.getFluidToDrain(state, this.field_145850_b, pos, side.func_176734_d());
            int n = drainAmount = fluidToDrain.isEmpty() ? fluidVoid.getDrainAmount(state, this.field_145850_b, pos, side.func_176734_d()) : 0;
            if (!fluidToDrain.isEmpty()) {
                this.mainTank.drain(fluidToDrain, IFluidHandler.FluidAction.EXECUTE);
            } else if (drainAmount > 0) {
                this.mainTank.drain(drainAmount, IFluidHandler.FluidAction.EXECUTE);
            }
        } else if (state.hasTileEntity() && (blockEntity = this.field_145850_b.func_175625_s(pos)) != null) {
            blockEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d()).ifPresent(tank -> FluidUtils.transferFromTo(this.mainTank, tank, 200));
        }
    }

    private void absorb(BlockState state, BlockPos pos, Direction side) {
        FluidStack fluid = FluidStack.EMPTY;
        FluidState fluidState = state.func_204520_s();
        if (state.func_177230_c() instanceof IFluidSource) {
            fluid = ((IFluidSource)state.func_177230_c()).getFluid(state, this.field_145850_b, pos, side.func_176734_d());
        } else if (fluidState.func_206886_c() == Fluids.field_204546_a.delegate.get()) {
            fluid = new FluidStack((Fluid)Fluids.field_204546_a, 50);
        }
        if (!fluid.isEmpty()) {
            this.mainTank.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    private void balanceTanks() {
        if (this.fromTank == null || this.toTank == null) {
            return;
        }
        FluidStack fluid = this.fromTank.getFluidInTank(0);
        FluidStack targetFluid = this.toTank.getFluidInTank(0);
        if (fluid.isEmpty() && targetFluid.isEmpty()) {
            return;
        }
        if (fluid.isEmpty() || targetFluid.isEmpty() || fluid.isFluidEqual(targetFluid)) {
            this.fromTank.applyPressure(this.toTank, this.field_174879_c.func_177956_o());
        }
    }

    private Optional<IMultiFluidHandler.Level> accessTankLevel() {
        return this.accessTankLevel(-1);
    }

    private Optional<IMultiFluidHandler.Level> accessTankLevel(int tankIndex) {
        return this.getMultiCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, tankIndex).filter(handler -> handler instanceof IMultiFluidHandler).map(handler -> ((IMultiFluidHandler)handler).level(this.field_174879_c.func_177956_o()));
    }

    private void cacheFluidHandlers() {
        if (!this.capability.isPresent()) {
            Optional<IMultiFluidHandler.Level> capability = this.accessTankLevel();
            if (!capability.isPresent()) {
                return;
            }
            this.capability = LazyOptional.of(() -> this);
            this.mainTank = capability.get();
            this.toTank = null;
            this.fromTank = null;
        } else {
            this.capability.invalidate();
            this.capability = LazyOptional.empty();
            this.mainTank = EmptyFluidHandler.INSTANCE;
            if (this.parentCount() > 1) {
                this.fromTank = this.accessTankLevel(0).orElse(null);
                this.toTank = this.accessTankLevel(1).orElse(null);
            }
        }
        this.updateNeighbourForOutputSignal();
    }

    @Override
    public void onMultiValidation(MultiBlock multiBlock) {
        super.onMultiValidation(multiBlock);
        this.cacheFluidHandlers();
        LazyOptional capability = multiBlock.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.field_174879_c);
        IFluidHandler handler = (IFluidHandler)capability.orElse((Object)EmptyFluidHandler.INSTANCE);
        if (capability.isPresent() && !this.storedFluid.isEmpty() && handler.fill(this.storedFluid, IFluidHandler.FluidAction.SIMULATE) > 0) {
            int remainder = this.storedFluid.getAmount() - handler.fill(this.storedFluid, IFluidHandler.FluidAction.EXECUTE);
            this.setStoredFluid(remainder > 0 ? (FluidStack)Util.func_200696_a((Object)this.storedFluid.copy(), stack -> stack.setAmount(remainder)) : FluidStack.EMPTY);
        }
    }

    @Override
    public void onMultiInvalidation(MultiBlock multiBlock) {
        super.onMultiInvalidation(multiBlock);
        this.cacheFluidHandlers();
    }

    @Override
    public int getAnalogOutputSignal(BlockState state, World level, BlockPos pos) {
        if (!this.mode.get().isOutput()) {
            return 0;
        }
        int capacity = this.mainTank.getTankCapacity(0);
        float proportion = capacity > 0 ? (float)this.mainTank.getFluidInTank(0).getAmount() / (float)capacity : 0.0f;
        return MathHelper.func_76141_d((float)(proportion * 14.0f)) + (proportion > 0.0f ? 1 : 0);
    }

    public int getTanks() {
        return this.mainTank.getTanks();
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.mainTank.getFluidInTank(tank);
    }

    public int getTankCapacity(int tank) {
        return this.mainTank.getTankCapacity(tank);
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return this.mainTank.isFluidValid(tank, stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.mode.get().isOutput() ? 0 : this.mainTank.fill(resource, action);
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.mode.get().isOutput() ? this.mainTank.drain(resource, action) : FluidStack.EMPTY;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return this.mode.get().isOutput() ? this.mainTank.drain(maxDrain, action) : FluidStack.EMPTY;
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        if (tag.func_150297_b("StoredFluid", 10)) {
            this.storedFluid = FluidStack.loadFluidStackFromNBT((CompoundNBT)tag.func_74775_l("StoredFluid"));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        if (!this.storedFluid.isEmpty()) {
            tag.func_218657_a("StoredFluid", (INBT)this.storedFluid.writeToNBT(new CompoundNBT()));
        }
        return tag;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> type, @Nullable Direction side) {
        return !this.field_145846_f && this.capability.isPresent() && type == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? this.capability.cast() : super.getCapability(type, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.capability.invalidate();
    }

    public FluidStack getStoredFluid() {
        return this.storedFluid;
    }

    public void setStoredFluid(FluidStack stack) {
        this.storedFluid = stack;
        this.func_70296_d();
    }

    public boolean hasStoredFluid() {
        return !this.storedFluid.isEmpty();
    }
}

